/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.service;

import eu.europa.esig.dss.detailedreport.DetailedReportFacade;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.simplereport.SimpleReportFacade;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import eu.europa.esig.dss.standalone.exception.ApplicationException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FOPService {
    private static final Logger LOG = LoggerFactory.getLogger(FOPService.class);
    private static final String FOP_CONFIG = "/fop.xconf";
    private static FOPService instance;
    private FopFactory fopFactory;
    private FOUserAgent foUserAgent;

    private FOPService() {
        this.init();
    }

    private void init() {
        try (InputStream is = this.getClass().getResourceAsStream(FOP_CONFIG);){
            FopFactoryBuilder builder = new FopFactoryBuilder(this.getClass().getResource("/").toURI());
            builder.setAccessibility(true);
            DefaultConfigurationBuilder configurationBuilder = new DefaultConfigurationBuilder();
            DefaultConfiguration configuration = configurationBuilder.build(is);
            builder.setConfiguration(configuration);
            this.fopFactory = builder.build();
            this.foUserAgent = this.fopFactory.newFOUserAgent();
            this.foUserAgent.setCreator("DSS Standalone App");
            this.foUserAgent.setAccessibility(true);
        }
        catch (Exception e) {
            LOG.error(String.format("Unable to instantiate FOPService: %s", e.getMessage()), e);
            throw new ApplicationException(e);
        }
    }

    public static FOPService getInstance() {
        if (instance == null) {
            instance = new FOPService();
        }
        return instance;
    }

    public void generateSimpleReport(XmlSimpleReport simpleReport, OutputStream os) throws Exception {
        Fop fop = this.fopFactory.newFop("application/pdf", this.foUserAgent, os);
        SAXResult result = new SAXResult(fop.getDefaultHandler());
        SimpleReportFacade.newFacade().generatePdfReport(simpleReport, (Result)result);
    }

    public void generateDetailedReport(XmlDetailedReport detailedReport, OutputStream os) throws Exception {
        Fop fop = this.fopFactory.newFop("application/pdf", this.foUserAgent, os);
        SAXResult result = new SAXResult(fop.getDefaultHandler());
        DetailedReportFacade.newFacade().generatePdfReport(detailedReport, (Result)result);
    }
}

