/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.controller;

import eu.europa.esig.dss.standalone.controller.AbstractController;
import eu.europa.esig.dss.standalone.controller.validationresult.ValidationResultController;
import eu.europa.esig.dss.standalone.exception.ApplicationException;
import eu.europa.esig.dss.standalone.fx.CollectionFilesToStringConverter;
import eu.europa.esig.dss.standalone.fx.DSSFileChooser;
import eu.europa.esig.dss.standalone.fx.DSSFileChooserLoader;
import eu.europa.esig.dss.standalone.fx.FileToStringConverter;
import eu.europa.esig.dss.standalone.model.ValidationModel;
import eu.europa.esig.dss.standalone.source.TLValidationJobExecutor;
import eu.europa.esig.dss.standalone.task.ValidationTask;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.Reports;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationController
extends AbstractController {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationController.class);
    @FXML
    public Button signedFileSelectButton;
    @FXML
    public Button originalFilesSelectButton;
    @FXML
    public Button validationPolicySelectButton;
    @FXML
    public HBox validationBox;
    @FXML
    public Button validateButton;
    @FXML
    public Button signingCertificateSelectButton;
    @FXML
    public Button adjunctCertificatesSelectButton;
    @FXML
    public CheckBox userFriendlyIdentifiersSelectButton;
    @FXML
    public CheckBox semanticsSelectButton;
    @FXML
    private ValidationModel model;
    private ProgressIndicator progressValidateDocument;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.model = new ValidationModel();
        this.signedFileSelectButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                DSSFileChooser fileChooser = DSSFileChooserLoader.getInstance().createFileChooser("File to validate");
                File fileToValidate = fileChooser.showOpenDialog(ValidationController.this.stage);
                ValidationController.this.model.setFileToValidate(fileToValidate);
            }
        });
        this.signedFileSelectButton.textProperty().bindBidirectional(this.model.fileToValidateProperty(), new FileToStringConverter());
        this.originalFilesSelectButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                DSSFileChooser fileChooser = DSSFileChooserLoader.getInstance().createFileChooser("Original file(s)");
                List<File> files = fileChooser.showOpenMultipleDialog(ValidationController.this.stage);
                ValidationController.this.model.setOriginalDocuments(files);
            }
        });
        this.originalFilesSelectButton.textProperty().bindBidirectional(this.model.originalDocumentsProperty(), new CollectionFilesToStringConverter());
        this.validationPolicySelectButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                DSSFileChooser fileChooser = DSSFileChooserLoader.getInstance().createFileChooser("Validation policy file", "Validation policy (*.xml)", "*.xml");
                File validationPolicy = fileChooser.showOpenDialog(ValidationController.this.stage);
                ValidationController.this.model.setValidationPolicy(validationPolicy);
            }
        });
        this.validationPolicySelectButton.textProperty().bindBidirectional(this.model.fileValidationPolicyProperty(), new FileToStringConverter());
        this.signingCertificateSelectButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                DSSFileChooser fileChooser = DSSFileChooserLoader.getInstance().createFileChooser("Signing certificate file", "Certificate (*.cer, *.der, *.pem, *.crt)", "*.cer", "*.der", "*.pem", "*.crt");
                File signingCertificate = fileChooser.showOpenDialog(ValidationController.this.stage);
                ValidationController.this.model.setSigningCertificate(signingCertificate);
            }
        });
        this.signingCertificateSelectButton.textProperty().bindBidirectional(this.model.signingCertificateProperty(), new FileToStringConverter());
        this.adjunctCertificatesSelectButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                DSSFileChooser fileChooser = DSSFileChooserLoader.getInstance().createFileChooser("Adjunct certificates", "Certificates (*.cer, *.der, *.pem, *.crt)", "*.cer", "*.der", "*.pem", "*.crt");
                List<File> files = fileChooser.showOpenMultipleDialog(ValidationController.this.stage);
                ValidationController.this.model.setAdjunctCertificates(files);
            }
        });
        this.adjunctCertificatesSelectButton.textProperty().bindBidirectional(this.model.adjunctCertificatesProperty(), new CollectionFilesToStringConverter());
        this.userFriendlyIdentifiersSelectButton.selectedProperty().bindBidirectional((Property<Boolean>)this.model.userFriendlyIdentifiersProperty());
        this.semanticsSelectButton.selectedProperty().bindBidirectional((Property<Boolean>)this.model.semanticsProperty());
        final BooleanBinding disableValidateButton = this.model.fileToValidateProperty().isNull();
        this.validateButton.disableProperty().bind(disableValidateButton);
        this.validateButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                final Service<Reports> service = new Service<Reports>(){

                    @Override
                    protected Task<Reports> createTask() {
                        return new ValidationTask(ValidationController.this.model, TLValidationJobExecutor.getInstance().getCertificateSources());
                    }
                };
                service.setOnRunning(new EventHandler<WorkerStateEvent>(){

                    @Override
                    public void handle(WorkerStateEvent event) {
                        ValidationController.this.addLoader();
                    }
                });
                service.setOnSucceeded(new EventHandler<WorkerStateEvent>(){

                    @Override
                    public void handle(WorkerStateEvent event) {
                        ValidationController.this.removeLoader();
                        try {
                            Reports value = (Reports)service.getValue();
                            FXMLLoader loader = new FXMLLoader();
                            loader.setLocation(this.getClass().getResource("/fxml/validationresult/validationResult.fxml"));
                            Stage validationStage = new Stage();
                            validationStage.setTitle(String.format("Validation result \"%s\"", value.getSimpleReport().getDocumentFilename()));
                            validationStage.getIcons().add(new Image("/dss-logo.png"));
                            validationStage.setResizable(true);
                            Scene scene = Utils.isCollectionNotEmpty(value.getSimpleReportJaxb().getSignatureOrTimestamp()) ? new Scene((Parent)loader.load(), 1000.0, 550.0) : new Scene((Parent)loader.load(), 150.0, 75.0);
                            scene.getStylesheets().add("/styles/style.css");
                            validationStage.setScene(scene);
                            validationStage.setX(ValidationController.this.validationBox.getScene().getWindow().getX() + 30.0);
                            validationStage.setY(ValidationController.this.validationBox.getScene().getWindow().getY() + 30.0);
                            ValidationResultController controller = (ValidationResultController)loader.getController();
                            controller.setStage(validationStage);
                            controller.initialize(value);
                            validationStage.show();
                            LOG.info("Successfully validated document with name '{}'", (Object)value.getSimpleReport().getDocumentFilename());
                        }
                        catch (Exception e) {
                            LOG.error(String.format("An error occurred: %s", e.getMessage()), e);
                            throw new ApplicationException(e);
                        }
                    }
                });
                service.setOnFailed(new EventHandler<WorkerStateEvent>(){

                    @Override
                    public void handle(WorkerStateEvent event) {
                        ValidationController.this.removeLoader();
                        String errorMessage = "Oops an error occurred : " + service.getMessage();
                        LOG.error(errorMessage, service.getException());
                        Alert alert = new Alert(Alert.AlertType.ERROR, errorMessage, ButtonType.CLOSE);
                        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                        alert.showAndWait();
                        ValidationController.this.validateButton.disableProperty().bind(disableValidateButton);
                    }
                });
                ValidationController.this.validateButton.disableProperty().bind(service.runningProperty());
                service.start();
            }
        });
    }

    private void removeLoader() {
        this.validationBox.getChildren().remove(this.progressValidateDocument);
    }

    private void addLoader() {
        this.removeLoader();
        this.progressValidateDocument = new ProgressIndicator();
        this.validationBox.getChildren().add(this.progressValidateDocument);
    }
}

