/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.controller;

import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.SignatureTokenType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.standalone.controller.AbstractController;
import eu.europa.esig.dss.standalone.enumeration.SignatureOption;
import eu.europa.esig.dss.standalone.fx.CollectionFilesSelectToStringConverter;
import eu.europa.esig.dss.standalone.fx.DSSFileChooser;
import eu.europa.esig.dss.standalone.fx.DSSFileChooserLoader;
import eu.europa.esig.dss.standalone.fx.FileToStringConverter;
import eu.europa.esig.dss.standalone.model.SignatureModel;
import eu.europa.esig.dss.standalone.source.PropertyReader;
import eu.europa.esig.dss.standalone.source.TLValidationJobExecutor;
import eu.europa.esig.dss.standalone.task.SigningTask;
import eu.europa.esig.dss.utils.Utils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureController
extends AbstractController {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureController.class);
    private static final List<DigestAlgorithm> SUPPORTED_DIGEST_ALGORITHMS = Arrays.asList(DigestAlgorithm.SHA1, DigestAlgorithm.SHA224, DigestAlgorithm.SHA256, DigestAlgorithm.SHA384, DigestAlgorithm.SHA512, DigestAlgorithm.SHA3_224, DigestAlgorithm.SHA3_256, DigestAlgorithm.SHA3_384, DigestAlgorithm.SHA3_512);
    private List<DigestAlgorithm> sigFormSupportedDigestAlgorithms;
    private List<DigestAlgorithm> sigTokenTypeSupportedDigestAlgorithms;
    @FXML
    private Button fileSelectButton;
    @FXML
    public RadioButton asicNoneRadio;
    @FXML
    private RadioButton asicsRadio;
    @FXML
    private RadioButton asiceRadio;
    @FXML
    private ToggleGroup toggleAsicContainerType;
    @FXML
    private ToggleGroup toogleSigFormat;
    @FXML
    private ToggleGroup toggleSigPackaging;
    @FXML
    private ToggleGroup toggleSignatureOption;
    @FXML
    private RadioButton cadesRadio;
    @FXML
    private RadioButton padesRadio;
    @FXML
    private RadioButton xadesRadio;
    @FXML
    private RadioButton jadesRadio;
    @FXML
    private HBox hSignaturePackaging;
    @FXML
    private HBox hSignatureOption;
    @FXML
    private HBox hBoxDigestAlgos;
    @FXML
    private RadioButton envelopedRadio;
    @FXML
    private RadioButton envelopingRadio;
    @FXML
    private RadioButton detachedRadio;
    @FXML
    private RadioButton internallyDetachedRadio;
    @FXML
    private RadioButton tlSigning;
    @FXML
    private RadioButton xmlManifest;
    @FXML
    private ComboBox<SignatureLevel> comboLevel;
    @FXML
    private Label warningLabel;
    @FXML
    private ToggleGroup toggleDigestAlgo;
    @FXML
    private ToggleGroup toggleSigToken;
    @FXML
    private RadioButton pkcs11Radio;
    @FXML
    private RadioButton pkcs12Radio;
    @FXML
    private RadioButton mscapiRadio;
    @FXML
    private HBox hPkcsFile;
    @FXML
    private Label labelPkcs11File;
    @FXML
    private Label labelPkcs12File;
    @FXML
    private HBox hPkcsPassword;
    @FXML
    private Button pkcsFileButton;
    @FXML
    private PasswordField pkcsPassword;
    @FXML
    public Label warningMockTSALabel;
    @FXML
    private Button signButton;
    @FXML
    private ProgressIndicator progressSign;
    private ProgressIndicator progressRefreshLOTL;
    private SignatureModel model;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.model = new SignatureModel();
        this.hPkcsFile.managedProperty().bind(this.hPkcsFile.visibleProperty());
        this.hPkcsPassword.managedProperty().bind(this.hPkcsPassword.visibleProperty());
        this.labelPkcs11File.managedProperty().bind(this.labelPkcs11File.visibleProperty());
        this.labelPkcs12File.managedProperty().bind(this.labelPkcs12File.visibleProperty());
        this.fileSelectButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                DSSFileChooser fileChooser = DSSFileChooserLoader.getInstance().createFileChooser("File(s) to sign");
                List<File> filesToSign = fileChooser.showOpenMultipleDialog(SignatureController.this.stage);
                SignatureController.this.model.setFilesToSign(filesToSign);
                SignatureController.this.updatePropertiesForm();
            }
        });
        this.fileSelectButton.textProperty().bindBidirectional(this.model.filesToSignProperty(), new CollectionFilesSelectToStringConverter());
        this.asicNoneRadio.setSelected(true);
        this.asicsRadio.setUserData((Object)ASiCContainerType.ASiC_S);
        this.asiceRadio.setUserData((Object)ASiCContainerType.ASiC_E);
        this.toggleAsicContainerType.selectedToggleProperty().addListener(new ChangeListener<Toggle>(){

            @Override
            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                ASiCContainerType newContainerType = null;
                if (newValue != null) {
                    newContainerType = (ASiCContainerType)((Object)newValue.getUserData());
                }
                SignatureController.this.model.setAsicContainerType(newContainerType);
                SignatureController.this.updatePropertiesForm();
            }
        });
        this.cadesRadio.setUserData((Object)SignatureForm.CAdES);
        this.xadesRadio.setUserData((Object)SignatureForm.XAdES);
        this.padesRadio.setUserData((Object)SignatureForm.PAdES);
        this.jadesRadio.setUserData((Object)SignatureForm.JAdES);
        this.toogleSigFormat.selectedToggleProperty().addListener(new ChangeListener<Toggle>(){

            @Override
            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                SignatureForm newSigForm = null;
                if (newValue != null) {
                    newSigForm = (SignatureForm)((Object)newValue.getUserData());
                }
                SignatureController.this.model.setSignatureForm(newSigForm);
                SignatureController.this.updatePropertiesForm();
            }
        });
        this.envelopedRadio.setUserData((Object)SignaturePackaging.ENVELOPED);
        this.envelopingRadio.setUserData((Object)SignaturePackaging.ENVELOPING);
        this.detachedRadio.setUserData((Object)SignaturePackaging.DETACHED);
        this.internallyDetachedRadio.setUserData((Object)SignaturePackaging.INTERNALLY_DETACHED);
        this.toggleSigPackaging.selectedToggleProperty().addListener(new ChangeListener<Toggle>(){

            @Override
            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                SignaturePackaging newPackaging = null;
                if (newValue != null) {
                    newPackaging = (SignaturePackaging)((Object)newValue.getUserData());
                }
                SignatureController.this.model.setSignaturePackaging(newPackaging);
                SignatureController.this.updatePropertiesForm();
            }
        });
        this.tlSigning.setUserData((Object)SignatureOption.TL_SIGNING);
        this.xmlManifest.setUserData((Object)SignatureOption.XML_MANIFEST_SIGNING);
        this.toggleSignatureOption.selectedToggleProperty().addListener(new ChangeListener<Toggle>(){

            @Override
            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                SignatureOption signatureOption = null;
                if (newValue != null) {
                    signatureOption = (SignatureOption)((Object)newValue.getUserData());
                }
                SignatureController.this.model.setSignatureOption(signatureOption);
                SignatureController.this.updatePropertiesForm();
            }
        });
        for (DigestAlgorithm digestAlgo : SUPPORTED_DIGEST_ALGORITHMS) {
            RadioButton rb = new RadioButton(digestAlgo.getName());
            rb.setUserData(digestAlgo);
            rb.setToggleGroup(this.toggleDigestAlgo);
            this.hBoxDigestAlgos.getChildren().add(rb);
        }
        this.toggleDigestAlgo.selectedToggleProperty().addListener(new ChangeListener<Toggle>(){

            @Override
            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (newValue != null) {
                    DigestAlgorithm digestAlgorithm = (DigestAlgorithm)newValue.getUserData();
                    SignatureController.this.model.setDigestAlgorithm(digestAlgorithm);
                } else {
                    SignatureController.this.model.setDigestAlgorithm(null);
                }
            }
        });
        this.comboLevel.valueProperty().bindBidirectional(this.model.signatureLevelProperty());
        this.pkcs11Radio.setUserData((Object)SignatureTokenType.PKCS11);
        this.pkcs12Radio.setUserData((Object)SignatureTokenType.PKCS12);
        this.mscapiRadio.setUserData((Object)SignatureTokenType.MSCAPI);
        this.toggleSigToken.selectedToggleProperty().addListener(new ChangeListener<Toggle>(){

            @Override
            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (newValue != null) {
                    SignatureTokenType tokenType = (SignatureTokenType)((Object)newValue.getUserData());
                    SignatureController.this.model.setTokenType(tokenType);
                }
                SignatureController.this.model.setPkcsFile(null);
                SignatureController.this.model.setPassword(null);
                SignatureController.this.updatePropertiesForm();
            }
        });
        this.pkcsFileButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                DSSFileChooser fileChooser;
                switch (SignatureController.this.model.getTokenType()) {
                    case PKCS11: {
                        fileChooser = DSSFileChooserLoader.getInstance().createFileChooser("Library", "PKCS11 library (*.dll)", "*.dll");
                        break;
                    }
                    case PKCS12: {
                        fileChooser = DSSFileChooserLoader.getInstance().createFileChooser("Keystore", "PKCS12 keystore (*.p12, *.pfx)", "*.p12", "*.pfx");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Token type '%s' is not supported!", new Object[]{SignatureController.this.model.getTokenType()}));
                    }
                }
                File pkcsFile = fileChooser.showOpenDialog(SignatureController.this.stage);
                SignatureController.this.model.setPkcsFile(pkcsFile);
            }
        });
        this.pkcsFileButton.textProperty().bindBidirectional(this.model.pkcsFileProperty(), new FileToStringConverter());
        this.pkcsPassword.textProperty().bindBidirectional(this.model.passwordProperty());
        BooleanBinding isPkcs11Or12 = this.model.tokenTypeProperty().isEqualTo((Object)SignatureTokenType.PKCS11).or(this.model.tokenTypeProperty().isEqualTo((Object)SignatureTokenType.PKCS12));
        this.hPkcsFile.visibleProperty().bind(isPkcs11Or12);
        this.hPkcsPassword.visibleProperty().bind(isPkcs11Or12);
        this.labelPkcs11File.visibleProperty().bind(this.model.tokenTypeProperty().isEqualTo((Object)SignatureTokenType.PKCS11));
        this.labelPkcs12File.visibleProperty().bind(this.model.tokenTypeProperty().isEqualTo((Object)SignatureTokenType.PKCS12));
        BooleanBinding isMandatoryFieldsEmpty = this.model.filesToSignProperty().isNull().or(this.model.signatureFormProperty().isNull()).or(this.model.digestAlgorithmProperty().isNull()).or(this.model.tokenTypeProperty().isNull());
        BooleanBinding isPackagingEmpty = this.model.asicContainerTypeProperty().isNull().and(this.model.signaturePackagingProperty().isNull());
        BooleanBinding isEmptyFileOrPassword = this.model.pkcsFileProperty().isNull().or(this.model.passwordProperty().isEmpty());
        BooleanBinding isPKCSToken = this.model.tokenTypeProperty().isEqualTo((Object)SignatureTokenType.PKCS11).or(this.model.tokenTypeProperty().isEqualTo((Object)SignatureTokenType.PKCS12));
        BooleanBinding isPKCSIncomplete = isPKCSToken.and(isEmptyFileOrPassword);
        final BooleanBinding disableSignButton = isMandatoryFieldsEmpty.or(isPackagingEmpty).or(isPKCSIncomplete);
        this.signButton.disableProperty().bind(disableSignButton);
        this.signButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                SignatureController.this.progressSign.setDisable(false);
                final Service<DSSDocument> service = new Service<DSSDocument>(){

                    @Override
                    protected Task<DSSDocument> createTask() {
                        return new SigningTask(SignatureController.this.model, TLValidationJobExecutor.getInstance().getCertificateSources());
                    }
                };
                service.setOnSucceeded(new EventHandler<WorkerStateEvent>(){

                    @Override
                    public void handle(WorkerStateEvent event) {
                        SignatureController.this.save((DSSDocument)service.getValue());
                        SignatureController.this.signButton.disableProperty().bind(disableSignButton);
                        SignatureController.this.model.setPassword(null);
                    }
                });
                service.setOnFailed(new EventHandler<WorkerStateEvent>(){

                    @Override
                    public void handle(WorkerStateEvent event) {
                        String errorMessage = "Oops an error occurred : " + service.getMessage();
                        LOG.error(errorMessage, service.getException());
                        Alert alert = new Alert(Alert.AlertType.ERROR, errorMessage, ButtonType.CLOSE);
                        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                        alert.showAndWait();
                        SignatureController.this.signButton.disableProperty().bind(disableSignButton);
                        SignatureController.this.model.setPassword(null);
                    }
                });
                SignatureController.this.progressSign.progressProperty().bind(service.progressProperty());
                SignatureController.this.signButton.disableProperty().bind(service.runningProperty());
                service.start();
            }
        });
        this.warningMockTSALabel.setVisible(Utils.isTrue(PropertyReader.getBooleanProperty("timestamp.mock")));
    }

    private void updatePropertiesForm() {
        this.updateSignatureFormAndPackaging();
        this.updateSignatureLevelAndDigestAlgo();
        this.updateSignatureOption();
        this.reinitDigestAlgos();
    }

    private void updateSignatureFormAndPackaging() {
        if (this.model.getAsicContainerType() != null) {
            this.activateRadioButtons(this.xadesRadio, this.cadesRadio);
            this.disableRadioButtons(this.padesRadio, this.jadesRadio);
            this.disableRadioButtons(this.envelopingRadio, this.envelopedRadio, this.detachedRadio, this.internallyDetachedRadio);
            this.disableRadioButtons(this.tlSigning, this.xmlManifest);
        } else if (Utils.collectionSize(this.model.getFilesToSign()) > 1) {
            this.activateRadioButtons(this.xadesRadio, this.jadesRadio);
            this.disableRadioButtons(this.cadesRadio, this.padesRadio);
            this.disableRadioButtons(this.tlSigning, this.xmlManifest);
            if (this.model.getSignatureForm() != null) {
                switch (this.model.getSignatureForm()) {
                    case XAdES: {
                        this.activateRadioButtons(this.envelopingRadio, this.detachedRadio, this.internallyDetachedRadio);
                        this.disableRadioButtons(this.envelopedRadio);
                        break;
                    }
                    case JAdES: {
                        this.activateRadioButtons(this.detachedRadio);
                        this.disableRadioButtons(this.envelopedRadio, this.envelopingRadio, this.internallyDetachedRadio);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            this.activateRadioButtons(this.xadesRadio, this.cadesRadio, this.padesRadio, this.jadesRadio);
            if (this.model.getSignatureForm() != null) {
                switch (this.model.getSignatureForm()) {
                    case XAdES: {
                        if (this.model.getSignaturePackaging() == null && this.model.getSignatureOption() != null) {
                            switch (this.model.getSignatureOption()) {
                                case TL_SIGNING: {
                                    this.envelopedRadio.setSelected(true);
                                    break;
                                }
                                case XML_MANIFEST_SIGNING: {
                                    this.envelopingRadio.setSelected(true);
                                    break;
                                }
                            }
                        } else {
                            this.activateRadioButtons(this.envelopingRadio, this.envelopedRadio, this.detachedRadio, this.internallyDetachedRadio);
                        }
                        this.activateRadioButtons(this.tlSigning, this.xmlManifest);
                        break;
                    }
                    case JAdES: 
                    case CAdES: {
                        this.activateRadioButtons(this.envelopingRadio, this.detachedRadio);
                        this.disableRadioButtons(this.envelopedRadio, this.internallyDetachedRadio);
                        this.disableRadioButtons(this.tlSigning, this.xmlManifest);
                        break;
                    }
                    case PAdES: {
                        this.activateRadioButtons(this.envelopedRadio);
                        this.disableRadioButtons(this.envelopingRadio, this.detachedRadio, this.internallyDetachedRadio);
                        this.disableRadioButtons(this.tlSigning, this.xmlManifest);
                        break;
                    }
                }
            } else {
                this.reinitSignaturePackagings();
                this.reinitSignatureOptions();
            }
        }
    }

    private void updateSignatureLevelAndDigestAlgo() {
        this.sigFormSupportedDigestAlgorithms = new ArrayList<DigestAlgorithm>(SUPPORTED_DIGEST_ALGORITHMS);
        SignatureForm signatureForm = this.model.getSignatureForm();
        if (signatureForm != null) {
            block0 : switch (signatureForm) {
                case XAdES: {
                    if (this.model.getSignatureOption() != null) {
                        switch (this.model.getSignatureOption()) {
                            case TL_SIGNING: {
                                this.updateSignatureLevels(SignatureLevel.XAdES_BASELINE_B);
                                this.sigFormSupportedDigestAlgorithms = Arrays.asList(DigestAlgorithm.SHA256, DigestAlgorithm.SHA384, DigestAlgorithm.SHA512);
                                break block0;
                            }
                            case XML_MANIFEST_SIGNING: {
                                this.updateSignatureLevels(SignatureLevel.XAdES_BASELINE_B, SignatureLevel.XAdES_BASELINE_T, SignatureLevel.XAdES_BASELINE_LT, SignatureLevel.XAdES_BASELINE_LTA);
                                this.sigFormSupportedDigestAlgorithms = Arrays.asList(DigestAlgorithm.SHA256, DigestAlgorithm.SHA384, DigestAlgorithm.SHA512);
                                break block0;
                            }
                        }
                        break;
                    }
                    this.updateSignatureLevels(SignatureLevel.XAdES_BASELINE_B, SignatureLevel.XAdES_BASELINE_T, SignatureLevel.XAdES_BASELINE_LT, SignatureLevel.XAdES_BASELINE_LTA);
                    this.sigFormSupportedDigestAlgorithms = Arrays.asList(DigestAlgorithm.SHA1, DigestAlgorithm.SHA224, DigestAlgorithm.SHA256, DigestAlgorithm.SHA384, DigestAlgorithm.SHA512);
                    break;
                }
                case CAdES: {
                    this.updateSignatureLevels(SignatureLevel.CAdES_BASELINE_B, SignatureLevel.CAdES_BASELINE_T, SignatureLevel.CAdES_BASELINE_LT, SignatureLevel.CAdES_BASELINE_LTA);
                    break;
                }
                case PAdES: {
                    this.updateSignatureLevels(SignatureLevel.PAdES_BASELINE_B, SignatureLevel.PAdES_BASELINE_T, SignatureLevel.PAdES_BASELINE_LT, SignatureLevel.PAdES_BASELINE_LTA);
                    break;
                }
                case JAdES: {
                    this.sigFormSupportedDigestAlgorithms = Arrays.asList(DigestAlgorithm.SHA256, DigestAlgorithm.SHA384, DigestAlgorithm.SHA512);
                    this.updateSignatureLevels(SignatureLevel.JAdES_BASELINE_B, SignatureLevel.JAdES_BASELINE_T, SignatureLevel.JAdES_BASELINE_LT, SignatureLevel.JAdES_BASELINE_LTA);
                    break;
                }
                default: {
                    this.updateSignatureLevels(new SignatureLevel[0]);
                }
            }
        }
    }

    private void updateSignatureOption() {
        if (SignatureForm.XAdES.equals((Object)this.model.getSignatureForm()) && this.model.getSignaturePackaging() != null && Utils.collectionSize(this.model.getFilesToSign()) < 2) {
            switch (this.model.getSignaturePackaging()) {
                case ENVELOPED: {
                    this.tlSigning.setDisable(false);
                    this.disableRadioButtons(this.xmlManifest);
                    break;
                }
                case ENVELOPING: {
                    this.xmlManifest.setDisable(false);
                    this.disableRadioButtons(this.tlSigning);
                    break;
                }
                default: {
                    this.disableRadioButtons(this.tlSigning, this.xmlManifest);
                }
            }
        }
    }

    private void activateRadioButtons(RadioButton ... radioButtons) {
        for (RadioButton radioButton : radioButtons) {
            radioButton.setDisable(false);
            if (radioButtons.length != 1) continue;
            radioButton.setSelected(true);
        }
    }

    private void disableRadioButtons(RadioButton ... radioButtons) {
        for (RadioButton radioButton : radioButtons) {
            radioButton.setDisable(true);
            radioButton.setSelected(false);
        }
    }

    private void updateSignatureLevels(SignatureLevel ... signatureLevels) {
        this.comboLevel.setDisable(false);
        this.comboLevel.getItems().removeAll((Collection<?>)this.comboLevel.getItems());
        if (Utils.isArrayNotEmpty((Object[])signatureLevels)) {
            this.comboLevel.getItems().addAll((SignatureLevel[])signatureLevels);
            this.comboLevel.setValue(signatureLevels[0]);
        }
    }

    private void reinitSignaturePackagings() {
        this.disableRadioButtons(this.envelopingRadio, this.envelopedRadio, this.detachedRadio, this.internallyDetachedRadio);
    }

    private void reinitSignatureOptions() {
        this.disableRadioButtons(this.tlSigning, this.xmlManifest);
    }

    private void reinitDigestAlgos() {
        ArrayList<DigestAlgorithm> digestAlgos = new ArrayList<DigestAlgorithm>(SUPPORTED_DIGEST_ALGORITHMS);
        if (this.sigFormSupportedDigestAlgorithms != null) {
            digestAlgos.retainAll(this.sigFormSupportedDigestAlgorithms);
        }
        if (this.sigTokenTypeSupportedDigestAlgorithms != null) {
            digestAlgos.retainAll(this.sigTokenTypeSupportedDigestAlgorithms);
        }
        if (SignatureTokenType.MSCAPI.equals((Object)this.model.getTokenType())) {
            digestAlgos.remove(DigestAlgorithm.SHA224);
            digestAlgos.remove(DigestAlgorithm.SHA3_224);
            digestAlgos.remove(DigestAlgorithm.SHA3_256);
            digestAlgos.remove(DigestAlgorithm.SHA3_384);
            digestAlgos.remove(DigestAlgorithm.SHA3_512);
        }
        for (Node daButton : this.hBoxDigestAlgos.getChildren()) {
            DigestAlgorithm digestAlgorithm = (DigestAlgorithm)daButton.getUserData();
            if (digestAlgorithm == null) continue;
            if (digestAlgos.contains(digestAlgorithm)) {
                daButton.setDisable(false);
                continue;
            }
            daButton.setDisable(true);
            Toggle selectedToggle = this.toggleDigestAlgo.getSelectedToggle();
            if (selectedToggle == null || !digestAlgorithm.equals(selectedToggle.getUserData())) continue;
            selectedToggle.setSelected(false);
        }
    }
}

