/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.controller;

import eu.europa.esig.dss.standalone.controller.AbstractController;
import eu.europa.esig.dss.standalone.controller.ExtensionController;
import eu.europa.esig.dss.standalone.controller.SignatureController;
import eu.europa.esig.dss.standalone.controller.ValidationController;
import eu.europa.esig.dss.standalone.source.TLValidationJobExecutor;
import eu.europa.esig.dss.standalone.task.RefreshLOTLTask;
import eu.europa.esig.dss.tsl.job.TLValidationJob;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TabPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class MainController
extends AbstractController {
    public static final String NUMBER_OF_TRUSTED_CERTIFICATES = "Number of Trusted Certificates : ";
    @FXML
    public TabPane tabPane;
    @FXML
    private VBox signatureTab;
    @FXML
    private SignatureController signatureTabController;
    @FXML
    private VBox extensionTab;
    @FXML
    private ExtensionController extensionTabController;
    @FXML
    private VBox validationTab;
    @FXML
    private ValidationController validationTabController;
    @FXML
    private Button refreshLOTL;
    @FXML
    private HBox refreshBox;
    @FXML
    private Label nbCertificates;
    @FXML
    private Label warningLabel;
    private ProgressIndicator progressRefreshLOTL;
    private TLValidationJobExecutor jobBuilder;
    private TLValidationJob tlValidationJob;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.signatureTabController.setStage(this.stage);
        this.extensionTabController.setStage(this.stage);
        this.validationTabController.setStage(this.stage);
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.tabPane.getSelectionModel().selectFirst();
        this.jobBuilder = TLValidationJobExecutor.getInstance();
        this.tlValidationJob = this.jobBuilder.job();
        this.tlValidationJob.offlineRefresh();
        this.warningLabel.setVisible(false);
        this.updateLabelText();
        this.refreshLOTL.setOnAction(event -> {
            RefreshLOTLTask task = new RefreshLOTLTask(this.tlValidationJob);
            task.setOnRunning(new EventHandler<WorkerStateEvent>(){

                @Override
                public void handle(WorkerStateEvent event) {
                    MainController.this.warningLabel.setVisible(false);
                    MainController.this.addLoader();
                }
            });
            task.setOnSucceeded(new EventHandler<WorkerStateEvent>(){

                @Override
                public void handle(WorkerStateEvent event) {
                    MainController.this.removeLoader();
                    MainController.this.updateLabelText();
                }
            });
            task.setOnFailed(new EventHandler<WorkerStateEvent>(){

                @Override
                public void handle(WorkerStateEvent event) {
                    MainController.this.removeLoader();
                    MainController.this.warningLabel.setVisible(true);
                }
            });
            Thread readValThread = new Thread(task);
            readValThread.setDaemon(true);
            readValThread.start();
        });
    }

    private void updateLabelText() {
        this.nbCertificates.setText(NUMBER_OF_TRUSTED_CERTIFICATES + this.jobBuilder.getCertificateSources().getNumberOfCertificates());
    }

    private void removeLoader() {
        this.refreshBox.getChildren().remove(this.progressRefreshLOTL);
    }

    private void addLoader() {
        this.removeLoader();
        this.progressRefreshLOTL = new ProgressIndicator();
        this.refreshBox.getChildren().add(this.progressRefreshLOTL);
    }

    static {
        System.setProperty("glass.accessible.force", "false");
    }
}

