/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.enumerations.CertificateStatus;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.revocation.RevocationCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationTokenIdentifier;
import java.util.Date;
import java.util.Objects;

public abstract class RevocationToken<R extends Revocation>
extends Token {
    protected CertificateToken relatedCertificate;
    protected String sourceURL;
    protected RevocationOrigin externalOrigin;
    protected CertificateStatus status;
    protected Date productionDate;
    protected Date thisUpdate;
    protected Date nextUpdate;
    protected Date revocationDate;
    protected Date expiredCertsOnCRL;
    protected Date archiveCutOff;
    protected boolean certHashPresent = false;
    protected boolean certHashMatch = false;
    protected RevocationReason reason;

    protected RevocationToken() {
    }

    public abstract RevocationType getRevocationType();

    public CertificateToken getRelatedCertificate() {
        return this.relatedCertificate;
    }

    public String getRelatedCertificateId() {
        if (this.relatedCertificate != null) {
            return this.relatedCertificate.getDSSIdAsString();
        }
        return null;
    }

    public abstract CertificateToken getIssuerCertificateToken();

    public String getSourceURL() {
        return this.sourceURL;
    }

    public void setSourceURL(String sourceURL) {
        this.sourceURL = sourceURL;
    }

    public CertificateStatus getStatus() {
        return this.status;
    }

    public Date getProductionDate() {
        return this.productionDate;
    }

    @Override
    public Date getCreationDate() {
        return this.productionDate;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public Date getExpiredCertsOnCRL() {
        return this.expiredCertsOnCRL;
    }

    public Date getArchiveCutOff() {
        return this.archiveCutOff;
    }

    public boolean isCertHashPresent() {
        return this.certHashPresent;
    }

    public boolean isCertHashMatch() {
        return this.certHashMatch;
    }

    public RevocationReason getReason() {
        return this.reason;
    }

    public abstract RevocationCertificateSource getCertificateSource();

    public void setExternalOrigin(RevocationOrigin origin) {
        Objects.requireNonNull(origin, "The origin is null");
        if (origin.isInternalOrigin()) {
            throw new IllegalArgumentException("Only external are allowed");
        }
        this.externalOrigin = origin;
    }

    public RevocationOrigin getExternalOrigin() {
        return this.externalOrigin;
    }

    public boolean isInternal() {
        return this.externalOrigin == null;
    }

    @Override
    protected TokenIdentifier buildTokenIdentifier() {
        return new RevocationTokenIdentifier(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getDSSId().hashCode();
        result = 31 * result + (this.relatedCertificate == null ? 0 : this.relatedCertificate.getDSSIdAsString().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RevocationToken other = (RevocationToken)obj;
        if (!this.getDSSId().equals(other.getDSSId())) {
            return false;
        }
        if (this.relatedCertificate == null) {
            return other.relatedCertificate == null;
        }
        return this.relatedCertificate.equals(other.relatedCertificate);
    }
}

