/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.aia;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.NativeHTTPDataLoader;
import eu.europa.esig.dss.spi.client.http.Protocol;
import eu.europa.esig.dss.spi.x509.aia.OnlineAIASource;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAIASource
implements OnlineAIASource {
    private static final long serialVersionUID = 3968373722847675203L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAIASource.class);
    private DataLoader dataLoader;
    private Collection<Protocol> acceptedProtocols = Arrays.asList(Protocol.values());

    public DefaultAIASource() {
        this(new NativeHTTPDataLoader());
    }

    public DefaultAIASource(DataLoader dataLoader) {
        Objects.requireNonNull(dataLoader, "dataLoader cannot be null!");
        this.dataLoader = dataLoader;
    }

    @Override
    public void setDataLoader(DataLoader dataLoader) {
        Objects.requireNonNull(dataLoader, "dataLoader cannot be null!");
        this.dataLoader = dataLoader;
    }

    public void setAcceptedProtocols(Collection<Protocol> acceptedProtocols) {
        this.acceptedProtocols = acceptedProtocols;
    }

    @Override
    public Set<CertificateToken> getCertificatesByAIA(CertificateToken certificateToken) {
        List<OnlineAIASource.CertificatesAndAIAUrl> certificatesAndAIAUrls = this.getCertificatesAndAIAUrls(certificateToken);
        if (Utils.isCollectionNotEmpty(certificatesAndAIAUrls)) {
            LinkedHashSet<CertificateToken> allCertificates = new LinkedHashSet<CertificateToken>();
            for (OnlineAIASource.CertificatesAndAIAUrl certificatesByAiaUrl : certificatesAndAIAUrls) {
                List<CertificateToken> certificates = certificatesByAiaUrl.getCertificates();
                if (!Utils.isCollectionNotEmpty(certificates)) continue;
                allCertificates.addAll(certificates);
            }
            return allCertificates;
        }
        return Collections.emptySet();
    }

    @Override
    public List<OnlineAIASource.CertificatesAndAIAUrl> getCertificatesAndAIAUrls(CertificateToken certificateToken) {
        List<String> urls = CertificateExtensionsUtils.getCAIssuersAccessUrls(certificateToken);
        if (Utils.isCollectionEmpty(urls)) {
            LOG.info("There is no AIA extension for certificate download.");
            return Collections.emptyList();
        }
        if (this.dataLoader == null) {
            LOG.warn("There is no DataLoader defined to load Certificates from AIA extension (urls : {})", (Object)urls);
            return Collections.emptyList();
        }
        ArrayList<OnlineAIASource.CertificatesAndAIAUrl> certificatesAndAIAUrls = new ArrayList<OnlineAIASource.CertificatesAndAIAUrl>();
        for (String url : urls) {
            List<CertificateToken> loadedCertificates;
            block20: {
                byte[] bytes;
                if (!this.isUrlAccepted(url)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("The url '{}' is not accepted by the defined collection of Protocols. The entry is skipped.", (Object)url);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Loading certificate(s) from '{}'.", (Object)url);
                }
                try {
                    bytes = this.dataLoader.get(url);
                }
                catch (Exception e) {
                    String errorMessage = "Unable to download certificate from '{}': {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, url, e.getMessage(), e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)url, (Object)e.getMessage());
                    continue;
                }
                loadedCertificates = Collections.emptyList();
                if (Utils.isArrayNotEmpty(bytes)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Base64 content : {}", (Object)Utils.toBase64(bytes));
                    }
                    try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
                        loadedCertificates = DSSUtils.loadCertificateFromP7c(is);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} certificate(s) loaded from '{}'", (Object)loadedCertificates.size(), (Object)url);
                        }
                    }
                    catch (Exception e) {
                        String errorMessage = "Unable to parse certificate(s) from AIA (url: {}) : {}";
                        if (LOG.isDebugEnabled()) {
                            LOG.warn(errorMessage, url, e.getMessage(), e);
                            break block20;
                        }
                        LOG.warn(errorMessage, (Object)url, (Object)e.getMessage());
                    }
                } else {
                    LOG.warn("Empty content from {}.", (Object)url);
                }
            }
            certificatesAndAIAUrls.add(new OnlineAIASource.CertificatesAndAIAUrl(url, loadedCertificates));
        }
        return certificatesAndAIAUrls;
    }

    private boolean isUrlAccepted(String url) {
        if (Utils.isCollectionNotEmpty(this.acceptedProtocols)) {
            for (Protocol protocol : this.acceptedProtocols) {
                if (!protocol.isTheSame(url)) continue;
                return true;
            }
        }
        return false;
    }
}

