/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.tsl;

import eu.europa.esig.dss.enumerations.MRAStatus;
import eu.europa.esig.dss.spi.tsl.CertificateContentEquivalence;
import eu.europa.esig.dss.spi.tsl.ServiceTypeASi;
import eu.europa.esig.dss.spi.util.BaseTimeDependent;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ServiceEquivalence
extends BaseTimeDependent {
    private static final long serialVersionUID = 7729236073848705753L;
    private String legalInfoIdentifier;
    private MRAStatus status;
    private Map<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalence;
    private Map<List<String>, List<String>> statusEquivalence;
    private List<CertificateContentEquivalence> certificateContentEquivalences;
    private Map<String, String> qualifierEquivalence;

    public ServiceEquivalence(ServiceEquivalenceBuilder builder) {
        super(builder.startDate, builder.endDate);
        this.legalInfoIdentifier = builder.legalInfoIdentifier;
        this.status = builder.status;
        this.typeAsiEquivalence = builder.typeAsiEquivalence;
        this.statusEquivalence = builder.statusEquivalence;
        this.certificateContentEquivalences = builder.certificateContentEquivalences;
        this.qualifierEquivalence = builder.qualifierEquivalence;
    }

    public String getLegalInfoIdentifier() {
        return this.legalInfoIdentifier;
    }

    public void setLegalInfoIdentifier(String legalInfoIdentifier) {
        this.legalInfoIdentifier = legalInfoIdentifier;
    }

    public MRAStatus getStatus() {
        return this.status;
    }

    public void setStatus(MRAStatus status) {
        this.status = status;
    }

    public Map<ServiceTypeASi, ServiceTypeASi> getTypeAsiEquivalence() {
        return this.typeAsiEquivalence;
    }

    public void setTypeAsiEquivalence(Map<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalence) {
        this.typeAsiEquivalence = typeAsiEquivalence;
    }

    public Map<List<String>, List<String>> getStatusEquivalence() {
        return this.statusEquivalence;
    }

    public void setStatusEquivalence(Map<List<String>, List<String>> statusEquivalence) {
        this.statusEquivalence = statusEquivalence;
    }

    public List<CertificateContentEquivalence> getCertificateContentEquivalences() {
        return this.certificateContentEquivalences;
    }

    public void setCertificateContentEquivalences(List<CertificateContentEquivalence> certificateContentEquivalences) {
        this.certificateContentEquivalences = certificateContentEquivalences;
    }

    public Map<String, String> getQualifierEquivalence() {
        return this.qualifierEquivalence;
    }

    public void setQualifierEquivalence(Map<String, String> qualifierEquivalence) {
        this.qualifierEquivalence = qualifierEquivalence;
    }

    public static final class ServiceEquivalenceBuilder {
        private String legalInfoIdentifier;
        private MRAStatus status;
        private Date startDate;
        private Date endDate;
        private Map<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalence;
        private Map<List<String>, List<String>> statusEquivalence;
        private List<CertificateContentEquivalence> certificateContentEquivalences;
        private Map<String, String> qualifierEquivalence;

        public ServiceEquivalence build() {
            return new ServiceEquivalence(this);
        }

        public ServiceEquivalenceBuilder setLegalInfoIdentifier(String legalInfoIdentifier) {
            this.legalInfoIdentifier = legalInfoIdentifier;
            return this;
        }

        public ServiceEquivalenceBuilder setStatus(MRAStatus status) {
            this.status = status;
            return this;
        }

        public ServiceEquivalenceBuilder setStartDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public ServiceEquivalenceBuilder setEndDate(Date endDate) {
            this.endDate = endDate;
            return this;
        }

        public ServiceEquivalenceBuilder setTypeAsiEquivalence(Map<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalence) {
            this.typeAsiEquivalence = typeAsiEquivalence;
            return this;
        }

        public ServiceEquivalenceBuilder setStatusEquivalence(Map<List<String>, List<String>> statusEquivalence) {
            this.statusEquivalence = statusEquivalence;
            return this;
        }

        public ServiceEquivalenceBuilder setCertificateContentEquivalences(List<CertificateContentEquivalence> certificateContentEquivalences) {
            this.certificateContentEquivalences = certificateContentEquivalences;
            return this;
        }

        public ServiceEquivalenceBuilder setQualifierEquivalence(Map<String, String> qualifierEquivalence) {
            this.qualifierEquivalence = qualifierEquivalence;
            return this;
        }
    }
}

