/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.client.jdbc;

import eu.europa.esig.dss.spi.client.jdbc.query.SqlQuery;
import eu.europa.esig.dss.spi.client.jdbc.query.SqlSelectQuery;
import eu.europa.esig.dss.spi.client.jdbc.record.SqlRecord;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCacheConnector {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCacheConnector.class);
    private final DataSource dataSource;

    public JdbcCacheConnector(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(SqlQuery query, Object ... arguments) {
        Objects.requireNonNull(query, "Query cannot be null!");
        Connection c = null;
        PreparedStatement s2 = null;
        try {
            int ii;
            c = this.dataSource.getConnection();
            c.setAutoCommit(false);
            s2 = c.prepareStatement(query.getQueryString());
            for (ii = 0; ii < arguments.length; ++ii) {
                s2.setObject(ii + 1, arguments[ii]);
            }
            ii = s2.executeUpdate();
            c.commit();
            LOG.debug("The query [{}] has been executed successfully", (Object)query);
            int n = ii;
            this.closeQuietly(c, s2, null);
            return n;
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to execute the query [{}]. Reason : '{}'", query, e.getMessage(), e);
                this.rollback(c);
                int n = 0;
                this.closeQuietly(c, s2, null);
                return n;
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s2, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SqlRecord> select(SqlSelectQuery selectQuery, Object ... arguments) {
        Connection c = null;
        PreparedStatement s2 = null;
        ResultSet rs = null;
        try {
            c = this.dataSource.getConnection();
            c.setAutoCommit(false);
            s2 = c.prepareStatement(selectQuery.getQueryString());
            for (int ii = 0; ii < arguments.length; ++ii) {
                s2.setObject(ii + 1, arguments[ii]);
            }
            rs = s2.executeQuery();
            Collection<SqlRecord> records = selectQuery.getRecords(rs);
            c.commit();
            LOG.debug("The SELECT query [{}] has been executed successfully.", (Object)selectQuery);
            Collection<SqlRecord> collection = records;
            this.closeQuietly(c, s2, rs);
            return collection;
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to execute query [{}]. Reason : {}", selectQuery, e.getMessage(), e);
                this.rollback(c);
                Set<SqlRecord> set = Collections.emptySet();
                this.closeQuietly(c, s2, rs);
                return set;
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s2, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableQuery(SqlQuery query) {
        Connection c = null;
        Statement s2 = null;
        try {
            c = this.dataSource.getConnection();
            c.setAutoCommit(false);
            s2 = c.createStatement();
            boolean result = s2.execute(query.getQueryString());
            c.commit();
            boolean bl = result;
            this.closeQuietly(c, s2, null);
            return bl;
        }
        catch (SQLException e) {
            try {
                boolean bl = false;
                this.closeQuietly(c, s2, null);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s2, null);
                throw throwable;
            }
        }
    }

    public int executeThrowable(SqlQuery query) throws SQLException {
        Connection c = null;
        Statement s2 = null;
        try {
            c = this.dataSource.getConnection();
            c.setAutoCommit(false);
            s2 = c.createStatement();
            int result = s2.executeUpdate(query.getQueryString());
            c.commit();
            int n = result;
            this.closeQuietly(c, s2, null);
            return n;
        }
        catch (SQLException e) {
            try {
                this.rollback(c);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s2, null);
                throw throwable;
            }
        }
    }

    protected void rollback(Connection c) {
        if (c != null) {
            try {
                LOG.warn("Transaction is being rolled back");
                c.rollback();
            }
            catch (SQLException e) {
                LOG.error("Unable to rollback", e);
            }
        }
    }

    protected void closeQuietly(Connection c, Statement s2, ResultSet rs) {
        this.closeQuietly(rs);
        this.closeQuietly(s2);
        this.closeQuietly(c);
    }

    private void closeQuietly(Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeQuietly(Statement s2) {
        try {
            if (s2 != null) {
                s2.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeQuietly(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

