/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DSSMessageDigestCalculator {
    private final DigestAlgorithm digestAlgorithm;
    private final MessageDigest messageDigest;

    public DSSMessageDigestCalculator(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        this.messageDigest = this.toMessageDigest(digestAlgorithm);
    }

    private MessageDigest toMessageDigest(DigestAlgorithm digestAlgorithm) {
        try {
            return digestAlgorithm.getMessageDigest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new DSSException(String.format("Unable to build MessageDigest for the algorithm '%s' : %s", digestAlgorithm.getName(), e.getMessage()), e);
        }
    }

    public void update(byte byteToAdd) {
        this.messageDigest.update(byteToAdd);
    }

    public void update(byte[] bytes) {
        if (bytes != null) {
            this.messageDigest.update(bytes);
        }
    }

    public DSSMessageDigest getMessageDigest() {
        return new DSSMessageDigest(this.digestAlgorithm, this.messageDigest.digest());
    }
}

