/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.simplecertificatereport;

import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.jaxb.object.Message;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlChainItem;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlMessage;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlRevocation;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSimpleCertificateReport;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlTrustAnchor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SimpleCertificateReport {
    private final XmlSimpleCertificateReport simpleReport;

    public SimpleCertificateReport(XmlSimpleCertificateReport simpleReport) {
        this.simpleReport = simpleReport;
    }

    public Date getValidationTime() {
        return this.simpleReport.getValidationTime();
    }

    public List<String> getCertificateIds() {
        ArrayList<String> ids = new ArrayList<String>();
        List<XmlChainItem> chain = this.simpleReport.getChain();
        for (XmlChainItem xmlChainItem : chain) {
            ids.add(xmlChainItem.getId());
        }
        return ids;
    }

    public Date getCertificateNotBefore(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getNotBefore();
        }
        return null;
    }

    public Date getCertificateNotAfter(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getNotAfter();
        }
        return null;
    }

    public List<String> getCertificateAiaUrls(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getAiaUrls();
        }
        return Collections.emptyList();
    }

    public List<String> getCertificateCpsUrls(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getCpsUrls();
        }
        return Collections.emptyList();
    }

    public List<String> getCertificateCrlUrls(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getCrlUrls();
        }
        return Collections.emptyList();
    }

    public List<String> getCertificateOcspUrls(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getOcspUrls();
        }
        return Collections.emptyList();
    }

    public List<String> getCertificatePdsUrls(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getPdsUrls();
        }
        return Collections.emptyList();
    }

    public String getCertificateCommonName(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getCommonName();
        }
        return null;
    }

    public String getCertificateEmail(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getEmail();
        }
        return null;
    }

    public String getCertificateGivenName(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getGivenName();
        }
        return null;
    }

    public String getCertificateLocality(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getLocality();
        }
        return null;
    }

    public String getCertificateState(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getState();
        }
        return null;
    }

    public String getCertificateCountry(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getCountry();
        }
        return null;
    }

    public String getCertificateOrganizationName(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getOrganizationName();
        }
        return null;
    }

    public String getCertificateOrganizationUnit(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getOrganizationUnit();
        }
        return null;
    }

    public String getCertificatePseudonym(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getPseudonym();
        }
        return null;
    }

    public String getCertificateSurname(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubject().getSurname();
        }
        return null;
    }

    public Indication getCertificateIndication(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getIndication();
        }
        return null;
    }

    public SubIndication getCertificateSubIndication(String certificateId) {
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null) {
            return cert.getSubIndication();
        }
        return null;
    }

    public Date getCertificateRevocationDate(String certificateId) {
        XmlRevocation revocation;
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null && (revocation = cert.getRevocation()) != null) {
            return revocation.getRevocationDate();
        }
        return null;
    }

    public RevocationReason getCertificateRevocationReason(String certificateId) {
        XmlRevocation revocation;
        XmlChainItem cert = this.getCertificate(certificateId);
        if (cert != null && (revocation = cert.getRevocation()) != null) {
            return revocation.getRevocationReason();
        }
        return null;
    }

    public List<Message> getX509ValidationErrors(String certificateId) {
        XmlChainItem certificate = this.getCertificate(certificateId);
        if (certificate != null && certificate.getX509ValidationDetails() != null) {
            return this.convert(certificate.getX509ValidationDetails().getError());
        }
        return Collections.emptyList();
    }

    public List<Message> getX509ValidationWarnings(String certificateId) {
        XmlChainItem certificate = this.getCertificate(certificateId);
        if (certificate != null && certificate.getX509ValidationDetails() != null) {
            return this.convert(certificate.getX509ValidationDetails().getWarning());
        }
        return Collections.emptyList();
    }

    public List<Message> getX509ValidationInfo(String certificateId) {
        XmlChainItem certificate = this.getCertificate(certificateId);
        if (certificate != null && certificate.getX509ValidationDetails() != null) {
            return this.convert(certificate.getX509ValidationDetails().getInfo());
        }
        return Collections.emptyList();
    }

    public List<Message> getQualificationErrorsAtIssuanceTime(String certificateId) {
        XmlChainItem certificate = this.getCertificate(certificateId);
        if (certificate != null && certificate.getQualificationDetailsAtIssuance() != null) {
            return this.convert(certificate.getQualificationDetailsAtIssuance().getError());
        }
        return Collections.emptyList();
    }

    public List<Message> getQualificationWarningsAtIssuanceTime(String certificateId) {
        XmlChainItem certificate = this.getCertificate(certificateId);
        if (certificate != null && certificate.getQualificationDetailsAtIssuance() != null) {
            return this.convert(certificate.getQualificationDetailsAtIssuance().getWarning());
        }
        return Collections.emptyList();
    }

    public List<Message> getQualificationInfoAtIssuanceTime(String certificateId) {
        XmlChainItem certificate = this.getCertificate(certificateId);
        if (certificate != null && certificate.getQualificationDetailsAtIssuance() != null) {
            return this.convert(certificate.getQualificationDetailsAtIssuance().getInfo());
        }
        return Collections.emptyList();
    }

    public List<Message> getQualificationErrorsAtValidationTime(String certificateId) {
        XmlChainItem certificate = this.getCertificate(certificateId);
        if (certificate != null && certificate.getQualificationDetailsAtValidation() != null) {
            return this.convert(certificate.getQualificationDetailsAtValidation().getError());
        }
        return Collections.emptyList();
    }

    public List<Message> getQualificationWarningsAtValidationTime(String certificateId) {
        XmlChainItem certificate = this.getCertificate(certificateId);
        if (certificate != null && certificate.getQualificationDetailsAtValidation() != null) {
            return this.convert(certificate.getQualificationDetailsAtValidation().getWarning());
        }
        return Collections.emptyList();
    }

    public List<Message> getQualificationInfoAtValidationTime(String certificateId) {
        XmlChainItem certificate = this.getCertificate(certificateId);
        if (certificate != null && certificate.getQualificationDetailsAtValidation() != null) {
            return this.convert(certificate.getQualificationDetailsAtValidation().getInfo());
        }
        return Collections.emptyList();
    }

    private Message convert(XmlMessage v) {
        if (v != null) {
            return new Message(v.getKey(), v.getValue());
        }
        return null;
    }

    private List<Message> convert(Collection<XmlMessage> messages) {
        if (messages != null) {
            return messages.stream().map(this::convert).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public CertificateQualification getQualificationAtCertificateIssuance() {
        XmlChainItem cert = this.getFirstCertificate();
        return cert.getQualificationAtIssuance();
    }

    public CertificateQualification getQualificationAtValidationTime() {
        XmlChainItem cert = this.getFirstCertificate();
        return cert.getQualificationAtValidation();
    }

    public Set<String> getTrustAnchorVATNumbers() {
        HashSet<String> result = new HashSet<String>();
        XmlChainItem cert = this.getTrustAnchorCertificate();
        if (cert != null) {
            List<XmlTrustAnchor> trustAnchors = cert.getTrustAnchors();
            for (XmlTrustAnchor xmlTrustAnchor : trustAnchors) {
                result.add(xmlTrustAnchor.getTrustServiceProviderRegistrationId());
            }
        }
        return result;
    }

    private XmlChainItem getTrustAnchorCertificate() {
        List<XmlChainItem> chain = this.simpleReport.getChain();
        for (XmlChainItem xmlChainItem : chain) {
            if (xmlChainItem.getTrustAnchors() == null) continue;
            return xmlChainItem;
        }
        return null;
    }

    private XmlChainItem getFirstCertificate() {
        return this.simpleReport.getChain().get(0);
    }

    private XmlChainItem getCertificate(String certificateId) {
        List<XmlChainItem> chain = this.simpleReport.getChain();
        for (XmlChainItem xmlChainItem : chain) {
            if (!certificateId.equals(xmlChainItem.getId())) continue;
            return xmlChainItem;
        }
        return null;
    }

    public XmlSimpleCertificateReport getJaxbModel() {
        return this.simpleReport;
    }
}

