/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureRequirementsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureRequirementsChecker.class);
    private final CertificateVerifier certificateVerifier;
    private final AbstractSignatureParameters<?> signatureParameters;

    public SignatureRequirementsChecker(CertificateVerifier certificateVerifier, AbstractSignatureParameters<?> signatureParameters) {
        this.certificateVerifier = certificateVerifier;
        this.signatureParameters = signatureParameters;
    }

    public void assertSigningCertificateIsValid(CertificateToken certificateToken) {
        this.assertSigningCertificateIsYetValid(certificateToken);
        this.assertSigningCertificateIsNotExpired(certificateToken);
        this.assertCertificatesAreNotRevoked(certificateToken);
    }

    public void assertSigningCertificateIsValid(AdvancedSignature signature) {
        if (this.signatureParameters.isGenerateTBSWithoutCertificate() && signature.getCertificateSource().getNumberOfCertificates() == 0) {
            LOG.debug("Signature has been generated without certificate. Validity of the signing-certificate is not checked.");
            return;
        }
        CertificateToken signingCertificate = signature.getSigningCertificateToken();
        this.assertSigningCertificateIsYetValid(signingCertificate);
        this.assertSigningCertificateIsNotExpired(signingCertificate);
        this.assertCertificatesAreNotRevoked(signature);
    }

    private void assertSigningCertificateIsYetValid(CertificateToken certificateToken) {
        if (this.signatureParameters.isSignWithNotYetValidCertificate()) {
            return;
        }
        if (certificateToken == null) {
            throw new IllegalInputException("Signing certificate token was not found! Unable to verify its validity range. Use method setSignWithNotYetValidCertificate(true) to skip the check.");
        }
        Date notBefore = certificateToken.getNotBefore();
        Date notAfter = certificateToken.getNotAfter();
        Date signingDate = this.signatureParameters.bLevel().getSigningDate();
        if (signingDate.before(notBefore)) {
            throw new IllegalArgumentException(String.format("The signing certificate (notBefore : %s, notAfter : %s) is not yet valid at signing time %s! Change signing certificate or use method setSignWithNotYetValidCertificate(true).", DSSUtils.formatDateToRFC(notBefore), DSSUtils.formatDateToRFC(notAfter), DSSUtils.formatDateToRFC(signingDate)));
        }
    }

    private void assertSigningCertificateIsNotExpired(CertificateToken certificateToken) {
        if (this.signatureParameters.isSignWithExpiredCertificate()) {
            return;
        }
        if (certificateToken == null) {
            throw new IllegalInputException("Signing certificate token was not found! Unable to verify its validity range. Use method setSignWithExpiredCertificate(true) to skip the check.");
        }
        Date notBefore = certificateToken.getNotBefore();
        Date notAfter = certificateToken.getNotAfter();
        Date signingDate = this.signatureParameters.bLevel().getSigningDate();
        if (signingDate.after(notAfter)) {
            throw new IllegalArgumentException(String.format("The signing certificate (notBefore : %s, notAfter : %s) is expired at signing time %s! Change signing certificate or use method setSignWithExpiredCertificate(true).", DSSUtils.formatDateToRFC(notBefore), DSSUtils.formatDateToRFC(notAfter), DSSUtils.formatDateToRFC(signingDate)));
        }
    }

    private void assertCertificatesAreNotRevoked(CertificateToken certificateToken) {
        if (!this.signatureParameters.isCheckCertificateRevocation()) {
            return;
        }
        SignatureValidationContext validationContext = new SignatureValidationContext();
        validationContext.initialize(this.certificateVerifier);
        validationContext.setCurrentTime(this.signatureParameters.bLevel().getSigningDate());
        List<CertificateToken> certificateChain = this.signatureParameters.getCertificateChain();
        if (Utils.isCollectionEmpty(certificateChain)) {
            throw new NullPointerException("Certificate chain shall be provided for a revocation check! Please use parameters.setCertificateChain(...) method to provide a certificate chain.");
        }
        validationContext.addCertificateTokenForVerification(certificateToken);
        for (CertificateToken certificate : certificateChain) {
            validationContext.addCertificateTokenForVerification(certificate);
        }
        validationContext.validate();
        validationContext.checkAllRequiredRevocationDataPresent();
        validationContext.checkCertificateNotRevoked(certificateToken);
    }

    private void assertCertificatesAreNotRevoked(AdvancedSignature signature) {
        if (!this.signatureParameters.isCheckCertificateRevocation()) {
            return;
        }
        SignatureValidationContext validationContext = new SignatureValidationContext();
        validationContext.initialize(this.certificateVerifier);
        validationContext.setCurrentTime(this.signatureParameters.bLevel().getSigningDate());
        validationContext.addSignatureForVerification(signature);
        validationContext.validate();
        validationContext.checkAllRequiredRevocationDataPresent();
        validationContext.checkCertificatesNotRevoked(signature);
    }
}

