/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.ocsp;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.client.jdbc.query.SqlQuery;
import eu.europa.esig.dss.spi.client.jdbc.query.SqlSelectQuery;
import eu.europa.esig.dss.spi.client.jdbc.record.SqlRecord;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.revocation.JdbcRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;

public class JdbcCacheOCSPSource
extends JdbcRevocationSource<OCSP>
implements OCSPSource {
    private static final long serialVersionUID = 10480458323923489L;
    private static final SqlQuery SQL_INIT_CHECK_EXISTENCE = SqlQuery.createQuery("SELECT COUNT(*) FROM CACHED_OCSP");
    private static final SqlQuery SQL_INIT_CREATE_TABLE = SqlQuery.createQuery("CREATE TABLE CACHED_OCSP (ID VARCHAR(100), DATA BLOB, LOC VARCHAR(200))");
    private static final SqlQuery SQL_FIND_INSERT = SqlQuery.createQuery("INSERT INTO CACHED_OCSP (ID, DATA, LOC) VALUES (?, ?, ?)");
    private static final SqlQuery SQL_FIND_UPDATE = SqlQuery.createQuery("UPDATE CACHED_OCSP SET DATA = ?, LOC = ? WHERE ID = ?");
    private static final SqlQuery SQL_FIND_REMOVE = SqlQuery.createQuery("DELETE FROM CACHED_OCSP WHERE ID = ?");
    private static final SqlQuery SQL_DROP_TABLE = SqlQuery.createQuery("DROP TABLE CACHED_OCSP");
    private static final SqlSelectQuery SQL_FIND_QUERY = new SqlSelectQuery("SELECT * FROM CACHED_OCSP WHERE ID = ?"){

        @Override
        public SqlOCSPResponse getRecord(ResultSet rs) throws SQLException {
            SqlOCSPResponse response = new SqlOCSPResponse();
            response.id = rs.getString("ID");
            response.ocspBinary = rs.getBytes("DATA");
            response.ocspUrl = rs.getString("LOC");
            return response;
        }
    };

    @Override
    protected SqlQuery getCreateTableQuery() {
        return SQL_INIT_CREATE_TABLE;
    }

    @Override
    protected SqlQuery getTableExistenceQuery() {
        return SQL_INIT_CHECK_EXISTENCE;
    }

    @Override
    protected SqlQuery getDeleteTableQuery() {
        return SQL_DROP_TABLE;
    }

    @Override
    protected SqlQuery getInsertRevocationTokenEntryQuery() {
        return SQL_FIND_INSERT;
    }

    @Override
    protected SqlQuery getUpdateRevocationTokenEntryQuery() {
        return SQL_FIND_UPDATE;
    }

    @Override
    protected SqlQuery getRemoveRevocationTokenEntryQuery() {
        return SQL_FIND_REMOVE;
    }

    @Override
    protected SqlSelectQuery getRevocationDataExtractQuery() {
        return SQL_FIND_QUERY;
    }

    @Override
    protected final List<String> initRevocationTokenKeys(CertificateToken certificateToken) {
        return DSSRevocationUtils.getOcspRevocationTokenKeys(certificateToken);
    }

    @Override
    protected RevocationToken<OCSP> buildRevocationTokenFromResult(SqlRecord response, CertificateToken certificateToken, CertificateToken issuerCert) throws DSSExternalResourceException {
        try {
            SqlOCSPResponse ocspResponse = (SqlOCSPResponse)response;
            OCSPResp ocspResp = new OCSPResp(ocspResponse.ocspBinary);
            BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResp.getResponseObject();
            SingleResp latestSingleResponse = DSSRevocationUtils.getLatestSingleResponse(basicResponse, certificateToken, issuerCert);
            OCSPToken ocspToken = new OCSPToken(basicResponse, latestSingleResponse, certificateToken, issuerCert);
            ocspToken.setSourceURL(ocspResponse.ocspUrl);
            ocspToken.setExternalOrigin(RevocationOrigin.CACHED);
            return ocspToken;
        }
        catch (IOException | OCSPException e) {
            throw new DSSExternalResourceException(String.format("An error occurred during an attempt to obtain a revocation token. Reason : %s", e.getMessage()), e);
        }
    }

    @Override
    protected void insertRevocation(String revocationKey, RevocationToken<OCSP> token) {
        this.getJdbcCacheConnector().execute(this.getInsertRevocationTokenEntryQuery(), revocationKey, token.getEncoded(), token.getSourceURL());
    }

    @Override
    protected void updateRevocation(String revocationKey, RevocationToken<OCSP> token) {
        this.getJdbcCacheConnector().execute(this.getUpdateRevocationTokenEntryQuery(), token.getEncoded(), token.getSourceURL(), revocationKey);
    }

    @Override
    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return (OCSPToken)super.getRevocationToken(certificateToken, issuerCertificateToken);
    }

    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        return (OCSPToken)super.getRevocationToken(certificateToken, issuerCertificateToken, forceRefresh);
    }

    @Override
    protected String getRevocationTokenKey(CertificateToken certificateToken, String urlString) {
        return DSSRevocationUtils.getOcspRevocationKey(certificateToken, urlString);
    }

    protected static class SqlOCSPResponse
    implements SqlRecord {
        protected String id;
        protected byte[] ocspBinary;
        protected String ocspUrl;

        protected SqlOCSPResponse() {
        }
    }
}

