/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.Protocol;
import eu.europa.esig.dss.spi.x509.revocation.OnlineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSourceAlternateUrlsSupport;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineCRLSource
implements CRLSource,
RevocationSourceAlternateUrlsSupport<CRL>,
OnlineRevocationSource<CRL> {
    private static final long serialVersionUID = 6912729291417315212L;
    private static final Logger LOG = LoggerFactory.getLogger(OnlineCRLSource.class);
    private Protocol preferredProtocol;
    private DataLoader dataLoader;

    public OnlineCRLSource() {
        this.dataLoader = new CommonsDataLoader();
        LOG.trace("+OnlineCRLSource with the default data loader.");
    }

    public OnlineCRLSource(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
        LOG.trace("+OnlineCRLSource with the specific data loader.");
    }

    public void setPreferredProtocol(Protocol preferredProtocol) {
        this.preferredProtocol = preferredProtocol;
    }

    @Override
    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    @Override
    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return this.getRevocationToken(certificateToken, issuerCertificateToken, Collections.emptyList());
    }

    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerToken, List<String> alternativeUrls) {
        List<String> crlAccessUrls;
        Objects.requireNonNull(this.dataLoader, "DataLoader is not provided !");
        if (certificateToken == null) {
            return null;
        }
        if (Utils.isCollectionNotEmpty(alternativeUrls)) {
            LOG.info("CRL alternative urls : {}", (Object)alternativeUrls);
        }
        if (Utils.isCollectionEmpty(crlAccessUrls = CertificateExtensionsUtils.getCRLAccessUrls(certificateToken)) && Utils.isCollectionEmpty(alternativeUrls)) {
            LOG.debug("No CRL location found for {}", (Object)certificateToken.getDSSIdAsString());
            return null;
        }
        ArrayList<String> crlUrls = new ArrayList<String>();
        crlUrls.addAll(crlAccessUrls);
        crlUrls.addAll(alternativeUrls);
        OnlineRevocationSource.RevocationTokenAndUrl<CRL> revocationTokenAndUrl = this.getRevocationTokenAndUrl(certificateToken, issuerToken, crlUrls);
        if (revocationTokenAndUrl != null) {
            return (CRLToken)revocationTokenAndUrl.getRevocationToken();
        }
        LOG.debug("No CRL has been downloaded for a CertificateToken with Id '{}' from a list of urls : {}", (Object)certificateToken.getDSSIdAsString(), (Object)crlUrls);
        return null;
    }

    @Override
    public OnlineRevocationSource.RevocationTokenAndUrl<CRL> getRevocationTokenAndUrl(CertificateToken certificateToken, CertificateToken issuerToken) {
        Objects.requireNonNull(this.dataLoader, "DataLoader is not provided !");
        if (certificateToken == null) {
            return null;
        }
        List<String> crlUrls = CertificateExtensionsUtils.getCRLAccessUrls(certificateToken);
        if (Utils.isCollectionEmpty(crlUrls)) {
            LOG.debug("No CRL location found for {}", (Object)certificateToken.getDSSIdAsString());
            return null;
        }
        return this.getRevocationTokenAndUrl(certificateToken, issuerToken, crlUrls);
    }

    protected OnlineRevocationSource.RevocationTokenAndUrl<CRL> getRevocationTokenAndUrl(CertificateToken certificateToken, CertificateToken issuerToken, List<String> crlUrls) {
        DataLoader.DataAndUrl dataAndUrl;
        Objects.requireNonNull(this.dataLoader, "DataLoader is not provided !");
        if (issuerToken == null) {
            return null;
        }
        if (Utils.isCollectionEmpty(crlUrls)) {
            return null;
        }
        this.prioritize(crlUrls);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to retrieve a CRL from URL(s) {}...", (Object)crlUrls);
        }
        if ((dataAndUrl = this.downloadCrl(crlUrls)) == null) {
            return null;
        }
        try {
            CRLBinary crlBinary = CRLUtils.buildCRLBinary(dataAndUrl.getData());
            CRLValidity crlValidity = CRLUtils.buildCRLValidity(crlBinary, issuerToken);
            CRLToken crlToken = new CRLToken(certificateToken, crlValidity);
            crlToken.setExternalOrigin(RevocationOrigin.EXTERNAL);
            crlToken.setSourceURL(dataAndUrl.getUrlString());
            if (LOG.isDebugEnabled()) {
                LOG.debug("CRL '{}' has been retrieved from a source with URL '{}'.", (Object)crlToken.getDSSIdAsString(), (Object)dataAndUrl.getUrlString());
            }
            return new OnlineRevocationSource.RevocationTokenAndUrl<CRL>(dataAndUrl.getUrlString(), crlToken);
        }
        catch (Exception e) {
            LOG.warn("Unable to parse/validate the CRL (url: {}) : {}", dataAndUrl.getUrlString(), e.getMessage(), e);
            return null;
        }
    }

    private DataLoader.DataAndUrl downloadCrl(List<String> downloadUrls) {
        try {
            return this.dataLoader.get(downloadUrls);
        }
        catch (DSSException e) {
            LOG.warn("Unable to download CRL from URLs [{}]. Reason : [{}]", downloadUrls, e.getMessage(), e);
            return null;
        }
    }

    private void prioritize(List<String> urls) {
        if (this.preferredProtocol != null) {
            ArrayList<String> priorityUrls = new ArrayList<String>();
            for (String url : urls) {
                if (!this.preferredProtocol.isTheSame(url)) continue;
                priorityUrls.add(url);
            }
            urls.removeAll(priorityUrls);
            for (int ii = priorityUrls.size() - 1; ii >= 0; --ii) {
                urls.add(0, (String)priorityUrls.get(ii));
            }
        }
    }
}

