/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.visible;

import eu.europa.esig.dss.enumerations.ImageScaling;
import eu.europa.esig.dss.enumerations.SignerTextHorizontalAlignment;
import eu.europa.esig.dss.enumerations.SignerTextVerticalAlignment;
import eu.europa.esig.dss.enumerations.TextWrapping;
import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentHorizontal;
import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentVertical;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.visible.DPIUtils;
import eu.europa.esig.dss.pdf.visible.DSSFontMetrics;
import eu.europa.esig.dss.pdf.visible.ImageResolution;
import eu.europa.esig.dss.pdf.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.pdf.visible.SignatureFieldDimensionAndPosition;
import eu.europa.esig.dss.pdf.visible.TextFitter;
import eu.europa.esig.dss.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureFieldDimensionAndPositionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureFieldDimensionAndPositionBuilder.class);
    private static final String NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE = "not supported vertical alignment: ";
    private static final String NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE = "not supported horizontal alignment: ";
    private static final int DEFAULT_DPI = DPIUtils.getDpi(null);
    protected final SignatureImageParameters imageParameters;
    private final DSSFontMetrics fontMetrics;
    private final int pageRotation;
    private AnnotationBox pageBox;
    private AnnotationBox signatureFieldAnnotationBox;
    private SignatureFieldDimensionAndPosition dimensionAndPosition;

    public SignatureFieldDimensionAndPositionBuilder(SignatureImageParameters imageParameters, DSSFontMetrics fontMetrics, AnnotationBox pageBox, int pageRotation) {
        this.imageParameters = imageParameters;
        this.fontMetrics = fontMetrics;
        this.pageBox = pageBox;
        this.pageRotation = pageRotation;
    }

    public SignatureFieldDimensionAndPositionBuilder setSignatureFieldAnnotationBox(AnnotationBox signatureFieldAnnotationBox) {
        this.signatureFieldAnnotationBox = signatureFieldAnnotationBox;
        return this;
    }

    public SignatureFieldDimensionAndPosition build() {
        this.assertConfigurationValid();
        if (this.dimensionAndPosition == null) {
            this.dimensionAndPosition = new SignatureFieldDimensionAndPosition();
            this.initDpi();
            this.initRotation();
            this.assignImageBoundaryBox();
            this.assignImagePosition();
            this.alignHorizontally();
            this.alignVertically();
            this.rotateSignatureField();
        }
        return this.dimensionAndPosition;
    }

    private void initDpi() {
        ImageResolution imageResolution;
        if (this.imageParameters.getImage() != null) {
            try {
                imageResolution = ImageUtils.secureReadMetadata(this.imageParameters);
            }
            catch (Exception e) {
                LOG.warn("Cannot access the image metadata : {}. Returns default info.", (Object)e.getMessage());
                imageResolution = new ImageResolution(this.imageParameters.getDpi(), this.imageParameters.getDpi());
            }
        } else {
            imageResolution = new ImageResolution(DEFAULT_DPI, DEFAULT_DPI);
        }
        this.dimensionAndPosition.setImageResolution(imageResolution);
    }

    private void initRotation() {
        int rotation = ImageRotationUtils.getRotation(this.imageParameters.getRotation(), this.pageRotation);
        this.dimensionAndPosition.setGlobalRotation(rotation);
        if (ImageRotationUtils.isSwapOfDimensionsRequired(rotation)) {
            this.pageBox = ImageRotationUtils.swapDimensions(this.pageBox);
        }
    }

    private void assignImageBoundaryBox() {
        AnnotationBox imageBoundaryBox = this.getSignatureFieldBoundaryBox();
        float imageWidth = imageBoundaryBox.getWidth();
        float imageHeight = imageBoundaryBox.getHeight();
        float width = imageWidth;
        float height = imageHeight;
        SignatureFieldParameters fieldParameters = this.imageParameters.getFieldParameters();
        SignatureImageTextParameters textParameters = this.imageParameters.getTextParameters();
        if (textParameters != null && !textParameters.isEmpty()) {
            if (this.fontMetrics == null) {
                throw new NullPointerException("DSSFontMetrics shall be defined!");
            }
            float padding = textParameters.getPadding();
            float properTextSize = textParameters.getFont().getSize() * ImageUtils.getScaleFactor(this.imageParameters.getZoom());
            AnnotationBox estimatedTextBox = this.computeTextBox(textParameters, width, height, padding, properTextSize);
            TextFitter.Result fitResult = TextFitter.fitSignatureText(textParameters, properTextSize, this.fontMetrics, estimatedTextBox);
            this.dimensionAndPosition.setText(fitResult.getText());
            this.dimensionAndPosition.setTextSize(fitResult.getSize());
            AnnotationBox textBox = this.fontMetrics.computeTextBoundaryBox(fitResult.getText(), fitResult.getSize());
            float textHeight = Math.min(textBox.getHeight(), estimatedTextBox.getHeight());
            float textWidth = Math.min(textBox.getWidth(), estimatedTextBox.getWidth());
            textHeight += padding * 2.0f;
            textWidth += padding * 2.0f;
            switch (textParameters.getSignerTextPosition()) {
                case LEFT: {
                    if (fieldParameters.getWidth() == 0.0f) {
                        width += this.imageParameters.getImage() != null || width == 0.0f ? textWidth : 0.0f;
                    } else {
                        imageWidth -= this.imageParameters.getImage() != null || width == 0.0f ? textWidth : 0.0f;
                    }
                    if (fieldParameters.getHeight() == 0.0f) {
                        height = Math.max(height, textHeight);
                    }
                    this.dimensionAndPosition.setImageBoxX(width - imageWidth);
                    this.textImageVerticalAlignment(height, imageHeight, textHeight);
                    break;
                }
                case RIGHT: {
                    if (fieldParameters.getWidth() == 0.0f) {
                        width += this.imageParameters.getImage() != null || width == 0.0f ? textWidth : 0.0f;
                    } else {
                        imageWidth -= this.imageParameters.getImage() != null || width == 0.0f ? textWidth : 0.0f;
                    }
                    if (fieldParameters.getHeight() == 0.0f) {
                        height = Math.max(height, textHeight);
                    }
                    this.dimensionAndPosition.setTextBoxX(width - textWidth);
                    this.textImageVerticalAlignment(height, imageHeight, textHeight);
                    break;
                }
                case TOP: {
                    if (fieldParameters.getWidth() == 0.0f) {
                        width = Math.max(width, textWidth);
                    }
                    if (fieldParameters.getHeight() == 0.0f) {
                        height += this.imageParameters.getImage() != null || height == 0.0f ? textHeight : 0.0f;
                    } else {
                        imageHeight -= this.imageParameters.getImage() != null || height == 0.0f ? textHeight : 0.0f;
                    }
                    this.dimensionAndPosition.setTextBoxY(height - textHeight);
                    this.textImageHorizontalAlignment(width, imageWidth, textWidth);
                    break;
                }
                case BOTTOM: {
                    if (fieldParameters.getWidth() == 0.0f) {
                        width = Math.max(width, textWidth);
                    }
                    if (fieldParameters.getHeight() == 0.0f) {
                        height += this.imageParameters.getImage() != null || height == 0.0f ? textHeight : 0.0f;
                    } else {
                        imageHeight -= this.imageParameters.getImage() != null || height == 0.0f ? textHeight : 0.0f;
                    }
                    this.dimensionAndPosition.setImageBoxY(height - imageHeight);
                    this.textImageHorizontalAlignment(width, imageWidth, textWidth);
                    break;
                }
            }
            this.dimensionAndPosition.setTextBoxWidth(textWidth);
            this.dimensionAndPosition.setTextBoxHeight(textHeight);
            this.dimensionAndPosition.setTextX(this.dimensionAndPosition.getTextBoxX() + padding);
            this.dimensionAndPosition.setTextY(this.dimensionAndPosition.getTextBoxY() + padding);
            this.dimensionAndPosition.setTextWidth(this.dimensionAndPosition.getTextBoxWidth() - 2.0f * padding);
            this.dimensionAndPosition.setTextHeight(this.dimensionAndPosition.getTextBoxHeight() - 2.0f * padding);
        }
        if (ImageRotationUtils.isSwapOfDimensionsRequired(this.dimensionAndPosition.getGlobalRotation())) {
            float temp = width;
            width = height;
            height = temp;
        }
        this.dimensionAndPosition.setImageBoxWidth(imageWidth);
        this.dimensionAndPosition.setImageBoxHeight(imageHeight);
        this.dimensionAndPosition.setBoxWidth(width);
        this.dimensionAndPosition.setBoxHeight(height);
    }

    private AnnotationBox getSignatureFieldBoundaryBox() {
        float height;
        float width;
        if (this.signatureFieldAnnotationBox != null) {
            width = this.signatureFieldAnnotationBox.getWidth();
            height = this.signatureFieldAnnotationBox.getHeight();
            if (ImageRotationUtils.isSwapOfDimensionsRequired(this.dimensionAndPosition.getGlobalRotation())) {
                width = this.signatureFieldAnnotationBox.getHeight();
                height = this.signatureFieldAnnotationBox.getWidth();
            }
        } else {
            SignatureFieldParameters fieldParameters = this.imageParameters.getFieldParameters();
            width = fieldParameters.getWidth();
            height = fieldParameters.getHeight();
        }
        float scaleFactor = ImageUtils.getScaleFactor(this.imageParameters.getZoom());
        DSSDocument docImage = this.imageParameters.getImage();
        if (docImage != null) {
            AnnotationBox imageBoundaryBox = ImageUtils.getImageBoundaryBox(docImage);
            this.dimensionAndPosition.setImageWidth(imageBoundaryBox.getWidth() * scaleFactor);
            this.dimensionAndPosition.setImageHeight(imageBoundaryBox.getHeight() * scaleFactor);
            if (width == 0.0f) {
                width = imageBoundaryBox.getWidth();
                width *= DPIUtils.getPageScaleFactor(this.dimensionAndPosition.getImageResolution().getXDpi());
            }
            if (height == 0.0f) {
                height = imageBoundaryBox.getHeight();
                height *= DPIUtils.getPageScaleFactor(this.dimensionAndPosition.getImageResolution().getYDpi());
            }
        }
        return new AnnotationBox(0.0f, 0.0f, width *= scaleFactor, height *= scaleFactor);
    }

    private AnnotationBox computeTextBox(SignatureImageTextParameters textParameters, float width, float height, float padding, float fontSize) throws IllegalArgumentException {
        switch (textParameters.getTextWrapping()) {
            case FILL_BOX: 
            case FILL_BOX_AND_LINEBREAK: {
                return this.computeAutoFitTextDimensions(textParameters, width, height, padding);
            }
            case FONT_BASED: {
                return this.computeTextDimension(textParameters.getText(), fontSize);
            }
        }
        throw new IllegalArgumentException(String.format("The TextWrapping '%s' is not supported!", new Object[]{textParameters.getTextWrapping()}));
    }

    private AnnotationBox computeAutoFitTextDimensions(SignatureImageTextParameters textParameters, float width, float height, float padding) throws IllegalArgumentException {
        float doublePadding = 2.0f * padding;
        float boxWidth = width - doublePadding;
        float boxHeight = height - doublePadding;
        if (this.imageParameters.getImage() != null) {
            float imageWidth = this.dimensionAndPosition.getImageWidth();
            float imageHeight = this.dimensionAndPosition.getImageHeight();
            switch (this.imageParameters.getImageScaling()) {
                case STRETCH: 
                case CENTER: {
                    break;
                }
                case ZOOM_AND_CENTER: {
                    float imageRatio = imageWidth / imageHeight;
                    float boxRatio = width / height;
                    if (imageRatio < boxRatio) {
                        imageWidth = height * imageRatio;
                        imageHeight = height;
                        break;
                    }
                    imageWidth = width;
                    imageHeight = width / imageRatio;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("ImageScaling '%s' is not implemented!", new Object[]{this.imageParameters.getImageScaling()}));
                }
            }
            switch (textParameters.getSignerTextPosition()) {
                case LEFT: 
                case RIGHT: {
                    boxWidth = width - imageWidth - doublePadding;
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    boxHeight = height - imageHeight - doublePadding;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("The SignerTextPosition '%s' is not supported!", new Object[]{textParameters.getSignerTextPosition()}));
                }
            }
        }
        if (boxWidth <= 0.0f || boxHeight <= 0.0f) {
            throw new IllegalArgumentException("Unable to create a visual signature. The signature field box is too small!");
        }
        return new AnnotationBox(0.0f, 0.0f, boxWidth, boxHeight);
    }

    private AnnotationBox computeTextDimension(String text, float fontSize) {
        return this.fontMetrics.computeTextBoundaryBox(text, fontSize);
    }

    private void textImageVerticalAlignment(float height, float imageHeight, float textHeight) {
        SignerTextVerticalAlignment verticalAlignment = this.imageParameters.getTextParameters().getSignerTextVerticalAlignment();
        switch (verticalAlignment) {
            case TOP: {
                this.dimensionAndPosition.setTextBoxY(height - textHeight);
                this.dimensionAndPosition.setImageBoxY(height - imageHeight);
                break;
            }
            case BOTTOM: {
                this.dimensionAndPosition.setTextBoxY(0.0f);
                this.dimensionAndPosition.setImageBoxY(0.0f);
                break;
            }
            case MIDDLE: {
                this.dimensionAndPosition.setTextBoxY((height - textHeight) / 2.0f);
                this.dimensionAndPosition.setImageBoxY((height - imageHeight) / 2.0f);
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + (Object)((Object)verticalAlignment));
            }
        }
    }

    private void textImageHorizontalAlignment(float width, float imageWidth, float textWidth) {
        SignerTextHorizontalAlignment horizontalAlignment = this.imageParameters.getTextParameters().getSignerTextHorizontalAlignment();
        switch (horizontalAlignment) {
            case LEFT: {
                this.dimensionAndPosition.setTextBoxX(0.0f);
                this.dimensionAndPosition.setImageBoxX(0.0f);
                break;
            }
            case RIGHT: {
                this.dimensionAndPosition.setTextBoxX(width - textWidth);
                this.dimensionAndPosition.setImageBoxX(width - imageWidth);
                break;
            }
            case CENTER: {
                this.dimensionAndPosition.setTextBoxX((width - textWidth) / 2.0f);
                this.dimensionAndPosition.setImageBoxX((width - imageWidth) / 2.0f);
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + (Object)((Object)horizontalAlignment));
            }
        }
    }

    private void assignImagePosition() {
        if (this.imageParameters.getImage() != null) {
            switch (this.imageParameters.getImageScaling()) {
                case STRETCH: {
                    this.dimensionAndPosition.setImageX(this.dimensionAndPosition.getImageBoxX());
                    this.dimensionAndPosition.setImageY(this.dimensionAndPosition.getImageBoxY());
                    this.dimensionAndPosition.setImageWidth(this.dimensionAndPosition.getImageBoxWidth());
                    this.dimensionAndPosition.setImageHeight(this.dimensionAndPosition.getImageBoxHeight());
                    break;
                }
                case ZOOM_AND_CENTER: {
                    float y;
                    float x;
                    float height;
                    float width;
                    float imageRatio = this.dimensionAndPosition.getImageWidth() / this.dimensionAndPosition.getImageHeight();
                    float boxRatio = this.dimensionAndPosition.getImageBoxWidth() / this.dimensionAndPosition.getImageBoxHeight();
                    if (imageRatio < boxRatio) {
                        width = this.dimensionAndPosition.getImageBoxHeight() * imageRatio;
                        height = this.dimensionAndPosition.getImageBoxHeight();
                        x = this.dimensionAndPosition.getImageBoxX() + (this.dimensionAndPosition.getImageBoxWidth() - width) / 2.0f;
                        y = this.dimensionAndPosition.getImageBoxY();
                    } else {
                        width = this.dimensionAndPosition.getImageBoxWidth();
                        height = this.dimensionAndPosition.getImageBoxWidth() / imageRatio;
                        x = this.dimensionAndPosition.getImageBoxX();
                        y = this.dimensionAndPosition.getImageBoxY() + (this.dimensionAndPosition.getImageBoxHeight() - height) / 2.0f;
                    }
                    this.dimensionAndPosition.setImageX(x);
                    this.dimensionAndPosition.setImageY(y);
                    this.dimensionAndPosition.setImageWidth(width);
                    this.dimensionAndPosition.setImageHeight(height);
                    break;
                }
                case CENTER: {
                    this.dimensionAndPosition.setImageX(this.dimensionAndPosition.getImageBoxX() + (this.dimensionAndPosition.getImageBoxWidth() - this.dimensionAndPosition.getImageWidth()) / 2.0f);
                    this.dimensionAndPosition.setImageY(this.dimensionAndPosition.getImageBoxY() + (this.dimensionAndPosition.getImageBoxHeight() - this.dimensionAndPosition.getImageHeight()) / 2.0f);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("The ImageScaling '%s' is not supported!", new Object[]{this.imageParameters.getImageScaling()}));
                }
            }
        }
    }

    private void alignHorizontally() {
        float boxX;
        float boxWidth = this.dimensionAndPosition.getBoxWidth();
        if (ImageRotationUtils.isSwapOfDimensionsRequired(this.dimensionAndPosition.getGlobalRotation())) {
            boxWidth = this.dimensionAndPosition.getBoxHeight();
        }
        SignatureFieldParameters fieldParameters = this.imageParameters.getFieldParameters();
        VisualSignatureAlignmentHorizontal alignmentHorizontal = this.imageParameters.getVisualSignatureAlignmentHorizontal();
        switch (alignmentHorizontal) {
            case LEFT: 
            case NONE: {
                boxX = fieldParameters.getOriginX();
                break;
            }
            case CENTER: {
                boxX = (this.pageBox.getWidth() - boxWidth) / 2.0f;
                break;
            }
            case RIGHT: {
                boxX = this.pageBox.getWidth() - boxWidth - fieldParameters.getOriginX();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + (Object)((Object)alignmentHorizontal));
            }
        }
        this.dimensionAndPosition.setBoxX(boxX);
    }

    private void alignVertically() {
        float boxY;
        float boxHeight = this.dimensionAndPosition.getBoxHeight();
        if (ImageRotationUtils.isSwapOfDimensionsRequired(this.dimensionAndPosition.getGlobalRotation())) {
            boxHeight = this.dimensionAndPosition.getBoxWidth();
        }
        SignatureFieldParameters fieldParameters = this.imageParameters.getFieldParameters();
        VisualSignatureAlignmentVertical alignmentVertical = this.imageParameters.getVisualSignatureAlignmentVertical();
        switch (alignmentVertical) {
            case TOP: 
            case NONE: {
                boxY = fieldParameters.getOriginY();
                break;
            }
            case MIDDLE: {
                boxY = (this.pageBox.getHeight() - boxHeight) / 2.0f;
                break;
            }
            case BOTTOM: {
                boxY = this.pageBox.getHeight() - boxHeight - fieldParameters.getOriginY();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + (Object)((Object)alignmentVertical));
            }
        }
        this.dimensionAndPosition.setBoxY(boxY);
    }

    private void rotateSignatureField() {
        switch (this.dimensionAndPosition.getGlobalRotation()) {
            case 90: {
                float boxX = this.dimensionAndPosition.getBoxX();
                this.dimensionAndPosition.setBoxX(this.pageBox.getHeight() - this.dimensionAndPosition.getBoxY() - this.dimensionAndPosition.getBoxWidth());
                this.dimensionAndPosition.setBoxY(boxX);
                break;
            }
            case 180: {
                this.dimensionAndPosition.setBoxX(this.pageBox.getWidth() - this.dimensionAndPosition.getBoxX() - this.dimensionAndPosition.getBoxWidth());
                this.dimensionAndPosition.setBoxY(this.pageBox.getHeight() - this.dimensionAndPosition.getBoxY() - this.dimensionAndPosition.getBoxHeight());
                break;
            }
            case 270: {
                float boxX = this.dimensionAndPosition.getBoxX();
                this.dimensionAndPosition.setBoxX(this.dimensionAndPosition.getBoxY());
                this.dimensionAndPosition.setBoxY(this.pageBox.getWidth() - boxX - this.dimensionAndPosition.getBoxHeight());
                break;
            }
            case 0: 
            case 360: {
                break;
            }
            default: {
                throw new IllegalStateException("rotation angle must be 90, 180, 270 or 360 (0)");
            }
        }
    }

    private void assertConfigurationValid() {
        TextWrapping textWrapping;
        if (Utils.isStringNotEmpty(this.imageParameters.getTextParameters().getText()) && (TextWrapping.FILL_BOX.equals((Object)(textWrapping = this.imageParameters.getTextParameters().getTextWrapping())) || TextWrapping.FILL_BOX_AND_LINEBREAK.equals((Object)textWrapping))) {
            if (!(this.signatureFieldAnnotationBox != null && this.signatureFieldAnnotationBox.getWidth() != 0.0f && this.signatureFieldAnnotationBox.getHeight() != 0.0f || this.imageParameters.getFieldParameters() != null && this.imageParameters.getFieldParameters().getWidth() != 0.0f && this.imageParameters.getFieldParameters().getHeight() != 0.0f)) {
                throw new IllegalArgumentException(String.format("Signature field dimensions are not defined! Unable to use '%s' option.", new Object[]{this.imageParameters.getTextParameters().getTextWrapping()}));
            }
            if (this.imageParameters.getImage() != null && ImageScaling.STRETCH.equals((Object)this.imageParameters.getImageScaling())) {
                throw new IllegalArgumentException(String.format("ImageScaling '%s' is not applicable with text wrapping '%s' option!", new Object[]{this.imageParameters.getImageScaling(), textWrapping}));
            }
        }
    }
}

