/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDocumentReader;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;

public class PdfBoxUtils {
    private PdfBoxUtils() {
    }

    public static DSSDocument generateScreenshot(DSSDocument pdfDocument, int page) {
        return PdfBoxUtils.generateScreenshot(pdfDocument, (char[])null, page);
    }

    public static DSSDocument generateScreenshot(DSSDocument pdfDocument, String passwordProtection, int page) {
        return PdfBoxUtils.generateScreenshot(pdfDocument, passwordProtection, page, PAdESUtils.initializeDSSResourcesHandler());
    }

    public static DSSDocument generateScreenshot(DSSDocument pdfDocument, char[] passwordProtection, int page) {
        return PdfBoxUtils.generateScreenshot(pdfDocument, passwordProtection, page, PAdESUtils.initializeDSSResourcesHandler());
    }

    public static DSSDocument generateScreenshot(DSSDocument pdfDocument, String passwordProtection, int page, DSSResourcesHandler dssResourcesHandler) {
        BufferedImage bufferedImage = PdfBoxUtils.generateBufferedImageScreenshot(pdfDocument, passwordProtection, page);
        return ImageUtils.toDSSDocument(bufferedImage, dssResourcesHandler);
    }

    public static DSSDocument generateScreenshot(DSSDocument pdfDocument, char[] passwordProtection, int page, DSSResourcesHandler dssResourcesHandler) {
        BufferedImage bufferedImage = PdfBoxUtils.generateBufferedImageScreenshot(pdfDocument, passwordProtection, page);
        return ImageUtils.toDSSDocument(bufferedImage, dssResourcesHandler);
    }

    public static BufferedImage generateBufferedImageScreenshot(DSSDocument pdfDocument, String passwordProtection, int page) {
        return PdfBoxUtils.generateBufferedImageScreenshot(pdfDocument, passwordProtection != null ? passwordProtection.toCharArray() : null, page);
    }

    public static BufferedImage generateBufferedImageScreenshot(DSSDocument pdfDocument, char[] passwordProtection, int page) {
        BufferedImage bufferedImage;
        Objects.requireNonNull(pdfDocument, "pdfDocument shall be defined!");
        PdfBoxDocumentReader reader = new PdfBoxDocumentReader(pdfDocument, passwordProtection != null ? new String(passwordProtection) : null);
        try {
            bufferedImage = reader.generateImageScreenshot(page);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to generate a screenshot for the document with name '%s' for the page number '%s'. Reason : %s", pdfDocument.getName(), page, e.getMessage()), e);
            }
        }
        reader.close();
        return bufferedImage;
    }

    public static DSSDocument generateSubtractionImage(DSSDocument document1, DSSDocument document2, int page) {
        return PdfBoxUtils.generateSubtractionImage(document1, (char[])null, page, document2, (char[])null, page);
    }

    public static DSSDocument generateSubtractionImage(DSSDocument document1, String passwordDocument1, int pageDocument1, DSSDocument document2, String passwordDocument2, int pageDocument2) {
        return PdfBoxUtils.generateSubtractionImage(document1, passwordDocument1, pageDocument1, document2, passwordDocument2, pageDocument2, PAdESUtils.initializeDSSResourcesHandler());
    }

    public static DSSDocument generateSubtractionImage(DSSDocument document1, char[] passwordDocument1, int pageDocument1, DSSDocument document2, char[] passwordDocument2, int pageDocument2) {
        return PdfBoxUtils.generateSubtractionImage(document1, passwordDocument1, pageDocument1, document2, passwordDocument2, pageDocument2, PAdESUtils.initializeDSSResourcesHandler());
    }

    public static DSSDocument generateSubtractionImage(DSSDocument document1, String passwordDocument1, int pageDocument1, DSSDocument document2, String passwordDocument2, int pageDocument2, DSSResourcesHandler dssResourcesHandler) {
        return PdfBoxUtils.generateSubtractionImage(document1, passwordDocument1 != null ? passwordDocument1.toCharArray() : null, pageDocument1, document2, passwordDocument2 != null ? passwordDocument2.toCharArray() : null, pageDocument2, dssResourcesHandler);
    }

    public static DSSDocument generateSubtractionImage(DSSDocument document1, char[] passwordDocument1, int pageDocument1, DSSDocument document2, char[] passwordDocument2, int pageDocument2, DSSResourcesHandler dssResourcesHandler) {
        BufferedImage screenshotDoc1 = PdfBoxUtils.generateBufferedImageScreenshot(document1, passwordDocument1, pageDocument1);
        BufferedImage screenshotDoc2 = PdfBoxUtils.generateBufferedImageScreenshot(document2, passwordDocument2, pageDocument2);
        int width = Math.max(screenshotDoc1.getWidth(), screenshotDoc2.getWidth());
        int height = Math.max(screenshotDoc1.getHeight(), screenshotDoc2.getHeight());
        BufferedImage outputImage = PdfBoxUtils.getOutputImage(width, height);
        ImageUtils.drawSubtractionImage(screenshotDoc1, screenshotDoc2, outputImage);
        return ImageUtils.toDSSDocument(outputImage, dssResourcesHandler);
    }

    private static BufferedImage getOutputImage(int width, int height) {
        BufferedImage outputImage = new BufferedImage(width, height, 1);
        Graphics2D drawer = outputImage.createGraphics();
        drawer.setBackground(Color.WHITE);
        drawer.clearRect(0, 0, width, height);
        return outputImage;
    }

    public static PDAppearanceDictionary createSignatureAppearanceDictionary(PDDocument pdDocument, PDRectangle pdRectangle) {
        Objects.requireNonNull(pdDocument, "PDDocument cannot be null!");
        Objects.requireNonNull(pdRectangle, "PDRectangle cannot be null!");
        PDStream stream = new PDStream(pdDocument);
        PDFormXObject form = new PDFormXObject(stream);
        PDResources res = new PDResources();
        form.setResources(res);
        form.setFormType(1);
        form.setBBox(new PDRectangle(pdRectangle.getWidth(), pdRectangle.getHeight()));
        PDAppearanceDictionary appearance = new PDAppearanceDictionary();
        appearance.getCOSObject().setDirect(true);
        PDAppearanceStream appearanceStream = new PDAppearanceStream(form.getCOSObject());
        appearance.setNormalAppearance(appearanceStream);
        return appearance;
    }
}

