/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDict;
import eu.europa.esig.dss.spi.DSSUtils;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfBoxArray
implements PdfArray {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxArray.class);
    private COSArray wrapped;
    private PDDocument document;

    public PdfBoxArray(COSArray wrapped, PDDocument document) {
        this.wrapped = wrapped;
        this.document = document;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public byte[] getStreamBytes(int i) throws IOException {
        COSBase val = this.wrapped.get(i);
        return this.toBytes(val);
    }

    private byte[] toBytes(COSBase val) throws IOException {
        COSObject o;
        COSBase object;
        COSStream cosStream = null;
        if (val instanceof COSObject && (object = (o = (COSObject)val).getObject()) instanceof COSStream) {
            cosStream = (COSStream)object;
        }
        if (cosStream == null) {
            throw new DSSException("Cannot find value for " + val + " of class " + val.getClass());
        }
        try (COSInputStream is = cosStream.createInputStream();){
            byte[] byArray = DSSUtils.toByteArray(is);
            return byArray;
        }
    }

    @Override
    public Long getObjectNumber(int i) {
        COSBase val = this.wrapped.get(i);
        if (val instanceof COSObject) {
            return ((COSObject)val).getObjectNumber();
        }
        return null;
    }

    @Override
    public Number getNumber(int i) {
        COSBase val = this.wrapped.get(i);
        if (val != null) {
            if (val instanceof COSFloat) {
                return Float.valueOf(((COSFloat)val).floatValue());
            }
            if (val instanceof COSNumber) {
                return ((COSNumber)val).longValue();
            }
        }
        return null;
    }

    @Override
    public String getString(int i) {
        return this.wrapped.getString(i);
    }

    @Override
    public PdfDict getAsDict(int i) {
        COSDictionary cosDictionary = null;
        COSBase cosBaseObject = this.wrapped.get(i);
        if (cosBaseObject instanceof COSDictionary) {
            cosDictionary = (COSDictionary)cosBaseObject;
        } else if (cosBaseObject instanceof COSObject) {
            COSObject cosObject = (COSObject)cosBaseObject;
            cosDictionary = (COSDictionary)cosObject.getObject();
        }
        if (cosDictionary != null) {
            return new PdfBoxDict(cosDictionary, this.document);
        }
        LOG.warn("Unable to extract array entry as dictionary!");
        return null;
    }

    @Override
    public Object getObject(int i) {
        COSBase dictionaryObject = this.wrapped.getObject(i);
        if (dictionaryObject == null) {
            return null;
        }
        if (dictionaryObject instanceof COSDictionary || dictionaryObject instanceof COSObject) {
            return this.getAsDict(i);
        }
        if (dictionaryObject instanceof COSArray) {
            return new PdfBoxArray((COSArray)dictionaryObject, this.document);
        }
        if (dictionaryObject instanceof COSString) {
            return this.getString(i);
        }
        if (dictionaryObject instanceof COSName) {
            return this.wrapped.getName(i);
        }
        if (dictionaryObject instanceof COSNumber) {
            return this.getNumber(i);
        }
        if (dictionaryObject instanceof COSBoolean) {
            return ((COSBoolean)dictionaryObject).getValueAsObject();
        }
        if (dictionaryObject instanceof COSNull) {
            return null;
        }
        LOG.warn("Unable to process an entry on position '{}' of type '{}'.", (Object)i, (Object)dictionaryObject.getClass());
        return null;
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

