/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.SigFieldPermissions;
import eu.europa.esig.dss.pdf.modifications.DefaultPdfObjectModificationsFinder;
import eu.europa.esig.dss.pdf.modifications.ObjectModification;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModifications;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfSigDictWrapper
implements PdfSignatureDictionary {
    private static final Logger LOG = LoggerFactory.getLogger(PdfSigDictWrapper.class);
    private final PdfDict dictionary;
    private final CMSSignedData cmsSignedData;
    private final ByteRange byteRange;
    private boolean consistent;

    public PdfSigDictWrapper(PdfDict dictionary) {
        this.dictionary = dictionary;
        this.cmsSignedData = this.buildCMSSignedData();
        this.byteRange = this.buildByteRange();
    }

    private CMSSignedData buildCMSSignedData() {
        try {
            return new CMSSignedData(this.getContents());
        }
        catch (CMSException e) {
            throw new DSSException("Unable to build an instance of CMSSignedData", e);
        }
    }

    private ByteRange buildByteRange() {
        PdfArray byteRangeArray = this.dictionary.getAsArray("ByteRange");
        if (byteRangeArray == null) {
            throw new DSSException(String.format("Unable to retrieve the '%s' field value.", "ByteRange"));
        }
        int arraySize = byteRangeArray.size();
        int[] result = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            result[i] = byteRangeArray.getNumber(i).intValue();
        }
        return new ByteRange(result);
    }

    @Override
    public String getSignerName() {
        return this.dictionary.getStringValue("Name");
    }

    @Override
    public String getContactInfo() {
        return this.dictionary.getStringValue("ContactInfo");
    }

    @Override
    public String getReason() {
        return this.dictionary.getStringValue("Reason");
    }

    @Override
    public String getLocation() {
        return this.dictionary.getStringValue("Location");
    }

    @Override
    public Date getSigningDate() {
        return this.dictionary.getDateValue("M");
    }

    @Override
    public String getType() {
        return this.dictionary.getNameValue("Type");
    }

    @Override
    public String getFilter() {
        return this.dictionary.getNameValue("Filter");
    }

    @Override
    public String getSubFilter() {
        return this.dictionary.getNameValue("SubFilter");
    }

    @Override
    public CMSSignedData getCMSSignedData() {
        return this.cmsSignedData;
    }

    @Override
    public byte[] getContents() {
        try {
            return this.dictionary.getBinariesValue("Contents");
        }
        catch (IOException e) {
            throw new DSSException("Unable to retrieve the signature content", e);
        }
    }

    @Override
    public ByteRange getByteRange() {
        return this.byteRange;
    }

    @Override
    public CertificationPermission getDocMDP() {
        PdfArray referenceArray = this.dictionary.getAsArray("Reference");
        if (referenceArray != null) {
            for (int i = 0; i < referenceArray.size(); ++i) {
                PdfDict sigRef = referenceArray.getAsDict(i);
                if (!"DocMDP".equals(sigRef.getNameValue("TransformMethod"))) continue;
                PdfDict transformParams = sigRef.getAsDict("TransformParams");
                if (transformParams == null) {
                    LOG.warn("No '{}' dictionary found. Unable to perform a '{}' entry validation!", (Object)"TransformParams", (Object)"DocMDP");
                    continue;
                }
                Number permissions = transformParams.getNumberValue("P");
                if (permissions == null) {
                    LOG.warn("No '{}' parameter found. Unable to perform a '{}' entry validation!", (Object)"P", (Object)"DocMDP");
                    continue;
                }
                return CertificationPermission.fromCode(permissions.intValue());
            }
        }
        return null;
    }

    @Override
    public SigFieldPermissions getFieldMDP() {
        PdfArray referenceArray = this.dictionary.getAsArray("Reference");
        if (referenceArray != null) {
            for (int i = 0; i < referenceArray.size(); ++i) {
                PdfDict sigRef = referenceArray.getAsDict(i);
                if (!"FieldMDP".equals(sigRef.getNameValue("TransformMethod"))) continue;
                PdfDict dataDict = sigRef.getAsDict("Data");
                if (dataDict == null) {
                    LOG.warn("No '{}' dictionary found. Unable to perform a '{}' entry validation!", (Object)"Data", (Object)"FieldMDP");
                    continue;
                }
                String dataDictType = dataDict.getNameValue("Type");
                if (!"Catalog".equals(dataDictType)) {
                    LOG.warn("Unsupported type of '{}' dictionary found : '{}'. The '{}' validation skipped.", "Data", dataDictType, "FieldMDP");
                    continue;
                }
                PdfDict transformParams = sigRef.getAsDict("TransformParams");
                if (transformParams == null) {
                    LOG.warn("No '{}' dictionary found. Unable to perform a '{}' entry validation!", (Object)"TransformParams", (Object)"FieldMDP");
                    continue;
                }
                return PAdESUtils.extractPermissionsDictionary(transformParams);
            }
        }
        return null;
    }

    @Override
    public boolean checkConsistency(PdfSignatureDictionary signatureDictionary) {
        if (signatureDictionary == null) {
            LOG.warn("PdfSignatureDictionary from signed revision is null!");
            this.consistent = false;
        } else if (signatureDictionary instanceof PdfSigDictWrapper) {
            PdfSigDictWrapper dictionaryToCompare = (PdfSigDictWrapper)signatureDictionary;
            DefaultPdfObjectModificationsFinder modificationsFinder = new DefaultPdfObjectModificationsFinder();
            PdfObjectModifications pdfObjectModifications = modificationsFinder.find(dictionaryToCompare.dictionary, this.dictionary);
            List<ObjectModification> undefinedChanges = pdfObjectModifications.getUndefinedChanges();
            this.removeReferenceData(undefinedChanges);
            this.consistent = Utils.isCollectionEmpty(undefinedChanges);
            if (!this.consistent) {
                LOG.warn("The signature dictionary from final PDF revision is not equal to the signed revision version!");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Undefined modifications are : {}", (Object)undefinedChanges.stream().map(ObjectModification::getObjectTree).collect(Collectors.toList()));
                }
            }
        } else {
            LOG.warn("Provided PdfSignatureDictionary shall be instance of PdfSigDictWrapper!");
            this.consistent = false;
        }
        return this.consistent;
    }

    private void removeReferenceData(List<ObjectModification> modifications) {
        if (Utils.isCollectionNotEmpty(modifications)) {
            modifications.removeIf(objectModification -> objectModification.getObjectTree().getKeyChain().contains("Reference") && objectModification.getObjectTree().getKeyChain().contains("Data"));
        }
    }

    @Override
    public boolean isConsistent() {
        return this.consistent;
    }
}

