/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.alert.StatusAlert;
import eu.europa.esig.dss.alert.status.MessageStatus;
import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.alerts.ProtectedDocumentExceptionOnStatusAlert;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.PdfSignatureField;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.SigFieldPermissions;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfPermissionsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(PdfPermissionsChecker.class);
    private StatusAlert alertOnForbiddenSignatureCreation = new ProtectedDocumentExceptionOnStatusAlert();

    public void setAlertOnForbiddenSignatureCreation(StatusAlert alertOnForbiddenSignatureCreation) {
        this.alertOnForbiddenSignatureCreation = alertOnForbiddenSignatureCreation;
    }

    public void checkDocumentPermissions(PdfDocumentReader documentReader, SignatureFieldParameters fieldParameters) {
        if (!documentReader.isEncrypted() || documentReader.isOpenWithOwnerAccess()) {
            return;
        }
        if (this.isSignatureFieldFillIn(fieldParameters)) {
            if (!documentReader.canFillSignatureForm()) {
                this.alertOnForbiddenSignatureCreation("PDF Permissions dictionary does not allow fill in interactive form fields, including existing signature fields when document is open with user-access!");
            }
        } else if (!documentReader.canCreateSignatureField()) {
            this.alertOnForbiddenSignatureCreation("PDF Permissions dictionary does not allow modification or creation interactive form fields, including signature fields when document is open with user-access!");
        }
    }

    private boolean isSignatureFieldFillIn(SignatureFieldParameters fieldParameters) {
        return fieldParameters.getFieldId() != null;
    }

    public void checkSignatureRestrictionDictionaries(PdfDocumentReader documentReader, SignatureFieldParameters fieldParameters) {
        CertificationPermission certificationPermission = documentReader.getCertificationPermission();
        if (this.isDocumentChangeForbidden(certificationPermission)) {
            this.alertOnForbiddenSignatureCreation("DocMDP dictionary does not permit a new signature creation!");
        }
        if (documentReader.isUsageRightsSignaturePresent()) {
            LOG.info("A usage rights signature is present. The feature is deprecated and the entry is not handled.");
        }
        try {
            String signatureFieldId = fieldParameters.getFieldId();
            Map<PdfSignatureDictionary, List<PdfSignatureField>> sigDictionaries = documentReader.extractSigDictionaries();
            for (PdfSignatureDictionary pdfSignatureDictionary : sigDictionaries.keySet()) {
                SigFieldPermissions fieldMDP = pdfSignatureDictionary.getFieldMDP();
                if (fieldMDP == null || !this.isSignatureFieldCreationForbidden(fieldMDP, signatureFieldId)) continue;
                this.alertOnForbiddenSignatureCreation("FieldMDP dictionary does not permit a new signature creation!");
            }
            for (List list : sigDictionaries.values()) {
                for (PdfSignatureField signatureField : list) {
                    SigFieldPermissions lockDict = signatureField.getLockDictionary();
                    if (lockDict == null || lockDict.getCertificationPermission() == null || !this.isSignatureFieldCreationForbidden(lockDict, signatureFieldId)) continue;
                    this.alertOnForbiddenSignatureCreation("Lock dictionary does not permit a new signature creation!");
                }
            }
        }
        catch (IOException e) {
            LOG.warn("An error occurred while reading signature dictionary entries : {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean isDocumentChangeForbidden(CertificationPermission certificationPermission) {
        return CertificationPermission.NO_CHANGE_PERMITTED.equals((Object)certificationPermission);
    }

    private void alertOnForbiddenSignatureCreation(String message) {
        MessageStatus status = new MessageStatus();
        status.setMessage(String.format("The creation of new signatures is not permitted in the current document. Reason : %s", message));
        this.alertOnForbiddenSignatureCreation.alert(status);
    }

    private boolean isSignatureFieldCreationForbidden(SigFieldPermissions sigFieldPermissions, String signatureFieldId) {
        switch (sigFieldPermissions.getAction()) {
            case ALL: {
                return true;
            }
            case INCLUDE: {
                if (Utils.isStringEmpty(signatureFieldId)) {
                    return false;
                }
                if (!sigFieldPermissions.getFields().contains(signatureFieldId)) break;
                return true;
            }
            case EXCLUDE: {
                if (Utils.isStringEmpty(signatureFieldId)) {
                    return true;
                }
                if (sigFieldPermissions.getFields().contains(signatureFieldId)) break;
                return true;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The action value '%s' is not supported!", new Object[]{sigFieldPermissions.getAction()}));
            }
        }
        CertificationPermission certificationPermission = sigFieldPermissions.getCertificationPermission();
        return CertificationPermission.NO_CHANGE_PERMITTED.equals((Object)certificationPermission);
    }
}

