/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.dss;

import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVriDict;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfVriDictSource {
    private static final Logger LOG = LoggerFactory.getLogger(PdfVriDictSource.class);
    private final PdfVriDict pdfVriDict;

    public PdfVriDictSource(PdfDssDict dssDictionary, String vriDictionaryName) {
        List<PdfVriDict> vris = PAdESUtils.getVRIsWithName(dssDictionary, vriDictionaryName);
        this.pdfVriDict = Utils.collectionSize(vris) == 1 ? vris.get(0) : null;
    }

    public Date getVRICreationTime() {
        if (this.pdfVriDict != null) {
            return this.pdfVriDict.getTUTime();
        }
        return null;
    }

    public TimestampToken getTimestampToken() {
        if (this.pdfVriDict != null) {
            try {
                byte[] tsStream = this.pdfVriDict.getTSStream();
                if (Utils.isArrayNotEmpty(tsStream)) {
                    return new TimestampToken(this.pdfVriDict.getTSStream(), TimestampType.VRI_TIMESTAMP);
                }
            }
            catch (Exception e) {
                LOG.warn("An error occurred while extracting 'TS' timestamp from the corresponding /VRI dictionary : {}", (Object)e.getMessage());
            }
        }
        return null;
    }
}

