/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.pades.validation.PAdESBaselineRequirementsChecker;
import eu.europa.esig.dss.pades.validation.PAdESCRLSource;
import eu.europa.esig.dss.pades.validation.PAdESCertificateSource;
import eu.europa.esig.dss.pades.validation.PAdESOCSPSource;
import eu.europa.esig.dss.pades.validation.PAdESSignatureIdentifierBuilder;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.dss.PdfVriDictSource;
import eu.europa.esig.dss.pades.validation.timestamp.PAdESTimestampSource;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignatureIdentifierBuilder;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class PAdESSignature
extends CAdESSignature {
    private static final long serialVersionUID = 3818555396958720967L;
    private final PdfSignatureRevision pdfSignatureRevision;
    private final List<PdfRevision> documentRevisions;
    private ListCertificateSource dssCertificateSource;
    private ListRevocationSource<CRL> dssCRLSource;
    private ListRevocationSource<OCSP> dssOCSPSource;
    private String vriKey;

    protected PAdESSignature(PdfSignatureRevision pdfSignatureRevision, List<PdfRevision> documentRevisions) {
        super(pdfSignatureRevision.getCMSSignedData(), DSSASN1Utils.getFirstSignerInformation(pdfSignatureRevision.getCMSSignedData()));
        this.pdfSignatureRevision = pdfSignatureRevision;
        this.documentRevisions = documentRevisions;
        this.detachedContents = Arrays.asList(pdfSignatureRevision.getSignedData());
    }

    public void setDssCertificateSource(ListCertificateSource dssCertificateSource) {
        this.dssCertificateSource = dssCertificateSource;
    }

    public void setDssCRLSource(ListRevocationSource<CRL> dssCRLSource) {
        this.dssCRLSource = dssCRLSource;
    }

    public void setDssOCSPSource(ListRevocationSource<OCSP> dssOCSPSource) {
        this.dssOCSPSource = dssOCSPSource;
    }

    @Override
    public SignatureForm getSignatureForm() {
        if (this.hasPKCS7SubFilter()) {
            return SignatureForm.PKCS7;
        }
        return SignatureForm.PAdES;
    }

    @Override
    public SignatureCertificateSource getCertificateSource() {
        if (this.offlineCertificateSource == null) {
            this.offlineCertificateSource = new PAdESCertificateSource(this.pdfSignatureRevision, this.getVRIKey(), this.getSignerInformation());
        }
        return this.offlineCertificateSource;
    }

    @Override
    public OfflineCRLSource getCRLSource() {
        if (this.signatureCRLSource == null) {
            this.signatureCRLSource = new PAdESCRLSource(this.pdfSignatureRevision, this.getVRIKey(), this.getSignerInformation().getSignedAttributes());
        }
        return this.signatureCRLSource;
    }

    @Override
    public OfflineOCSPSource getOCSPSource() {
        if (this.signatureOCSPSource == null) {
            this.signatureOCSPSource = new PAdESOCSPSource(this.pdfSignatureRevision, this.getVRIKey(), this.getSignerInformation().getSignedAttributes());
        }
        return this.signatureOCSPSource;
    }

    @Override
    public ListCertificateSource getCompleteCertificateSource() {
        ListCertificateSource completeCertificateSource = super.getCompleteCertificateSource();
        if (this.dssCertificateSource != null) {
            completeCertificateSource.addAll(this.dssCertificateSource);
        }
        return completeCertificateSource;
    }

    @Override
    public ListRevocationSource<CRL> getCompleteCRLSource() {
        ListRevocationSource<CRL> completeCRLSource = super.getCompleteCRLSource();
        if (this.dssCRLSource != null) {
            completeCRLSource.addAll(this.dssCRLSource);
        }
        return completeCRLSource;
    }

    @Override
    public ListRevocationSource<OCSP> getCompleteOCSPSource() {
        ListRevocationSource<OCSP> completeOCSPSource = super.getCompleteOCSPSource();
        if (this.dssOCSPSource != null) {
            completeOCSPSource.addAll(this.dssOCSPSource);
        }
        return completeOCSPSource;
    }

    @Override
    public PAdESTimestampSource getTimestampSource() {
        if (this.signatureTimestampSource == null) {
            this.signatureTimestampSource = new PAdESTimestampSource(this, this.documentRevisions);
        }
        return (PAdESTimestampSource)this.signatureTimestampSource;
    }

    @Override
    public List<TimestampToken> getDocumentTimestamps() {
        return this.getTimestampSource().getDocumentTimestamps();
    }

    public List<TimestampToken> getVRITimestamps() {
        return this.getTimestampSource().getVriTimestamps();
    }

    @Override
    public Date getSigningTime() {
        return this.pdfSignatureRevision.getSigningDate();
    }

    @Override
    public String getContentIdentifier() {
        return null;
    }

    @Override
    public String getContentHints() {
        return null;
    }

    @Override
    public List<AdvancedSignature> getCounterSignatures() {
        return Collections.emptyList();
    }

    @Override
    public DSSDocument getOriginalDocument() {
        return this.pdfSignatureRevision.getSignedData();
    }

    @Override
    protected DSSDocument getSignerDocumentContent() {
        DSSDocument signerDocument = this.getOriginalDocument();
        if (signerDocument != null && this.getPdfSignatureDictionary() != null && "adbe.pkcs7.sha1".equals(this.getPdfSignatureDictionary().getSubFilter())) {
            signerDocument = new InMemoryDocument(Utils.fromBase64(signerDocument.getDigest(DigestAlgorithm.SHA1)));
        }
        return signerDocument;
    }

    @Override
    protected SignatureIdentifierBuilder getSignatureIdentifierBuilder() {
        return new PAdESSignatureIdentifierBuilder(this);
    }

    @Override
    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm digestAlgorithm) {
        byte[] contents = this.getPdfSignatureDictionary().getContents();
        byte[] digestValue = DSSUtils.digest(digestAlgorithm, contents);
        return new SignatureDigestReference(new Digest(digestAlgorithm, digestValue));
    }

    @Override
    public SignatureLevel getDataFoundUpToLevel() {
        SignatureForm signatureForm = this.getSignatureForm();
        if (SignatureForm.PAdES.equals((Object)signatureForm) && this.hasBProfile()) {
            if (!this.hasTProfile()) {
                return SignatureLevel.PAdES_BASELINE_B;
            }
            if (!this.hasLTProfile()) {
                return SignatureLevel.PAdES_BASELINE_T;
            }
            if (this.hasLTAProfile()) {
                return SignatureLevel.PAdES_BASELINE_LTA;
            }
            return SignatureLevel.PAdES_BASELINE_LT;
        }
        if (SignatureForm.PKCS7.equals((Object)signatureForm) && this.hasPKCS7Profile()) {
            if (!this.hasPKCS7TProfile()) {
                return SignatureLevel.PKCS7_B;
            }
            if (!this.hasPKCS7LTProfile()) {
                return SignatureLevel.PKCS7_T;
            }
            if (this.hasPKCS7LTAProfile()) {
                return SignatureLevel.PKCS7_LTA;
            }
            return SignatureLevel.PKCS7_LT;
        }
        return SignatureLevel.PDF_NOT_ETSI;
    }

    @Override
    protected PAdESBaselineRequirementsChecker getBaselineRequirementsChecker() {
        return (PAdESBaselineRequirementsChecker)super.getBaselineRequirementsChecker();
    }

    @Override
    protected PAdESBaselineRequirementsChecker createBaselineRequirementsChecker() {
        return new PAdESBaselineRequirementsChecker(this, this.offlineCertificateVerifier);
    }

    public boolean hasPKCS7Profile() {
        return this.getBaselineRequirementsChecker().hasPKCS7Profile();
    }

    public boolean hasPKCS7TProfile() {
        return this.getBaselineRequirementsChecker().hasPKCS7TProfile();
    }

    public boolean hasPKCS7LTProfile() {
        return this.getBaselineRequirementsChecker().hasPKCS7LTProfile();
    }

    public boolean hasPKCS7LTAProfile() {
        return this.getBaselineRequirementsChecker().hasPKCS7LTAProfile();
    }

    @Override
    public boolean hasAProfile() {
        return this.getBaselineRequirementsChecker().hasExtendedAProfile();
    }

    public PdfDssDict getDssDictionary() {
        return this.pdfSignatureRevision.getDssDictionary();
    }

    private boolean hasPKCS7SubFilter() {
        if (this.pdfSignatureRevision != null) {
            String subFilter = this.pdfSignatureRevision.getPdfSigDictInfo().getSubFilter();
            return "adbe.pkcs7.detached".equals(subFilter) || "adbe.pkcs7.sha1".equals(subFilter);
        }
        return false;
    }

    public PdfSignatureRevision getPdfRevision() {
        return this.pdfSignatureRevision;
    }

    public PdfSignatureDictionary getPdfSignatureDictionary() {
        return this.pdfSignatureRevision.getPdfSigDictInfo();
    }

    public String getVRIKey() {
        if (this.vriKey == null) {
            byte[] digest = DSSUtils.digest(DigestAlgorithm.SHA1, this.getPdfSignatureDictionary().getContents());
            String vriId = Utils.toHex(digest);
            this.vriKey = vriId.toUpperCase();
        }
        return this.vriKey;
    }

    public Date getVRICreationTime() {
        PdfDssDict dssDictionary = this.getDssDictionary();
        if (dssDictionary != null) {
            PdfVriDictSource pdfVriDictTimestampSource = new PdfVriDictSource(dssDictionary, this.getVRIKey());
            return pdfVriDictTimestampSource.getVRICreationTime();
        }
        return null;
    }

    @Override
    public void addExternalTimestamp(TimestampToken timestamp) {
        throw new UnsupportedOperationException("The action is not supported for PAdES!");
    }
}

