/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.FileNameBuilder;
import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CAdESUnsignedAttributes;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PAdESService;
import eu.europa.esig.dss.pades.validation.CMSForPAdESBaselineRequirementsChecker;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.ServiceLoaderPdfObjFactory;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESWithExternalCMSService
implements Serializable {
    private static final long serialVersionUID = -6168823023670905054L;
    private static final Logger LOG = LoggerFactory.getLogger(PAdESWithExternalCMSService.class);
    private CertificateVerifier certificateVerifier;
    private TSPSource tspSource;
    private IPdfObjFactory pdfObjFactory = new ServiceLoaderPdfObjFactory();

    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    public void setPdfObjFactory(IPdfObjFactory pdfObjFactory) {
        Objects.requireNonNull(pdfObjFactory, "PdfObjFactory is null");
        this.pdfObjFactory = pdfObjFactory;
    }

    public DSSMessageDigest getMessageDigest(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertDocumentValid(toSignDocument);
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        return pdfSignatureService.messageDigest(toSignDocument, parameters);
    }

    public DSSDocument signDocument(DSSDocument toSignDocument, PAdESSignatureParameters parameters, DSSDocument cmsDocument) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(parameters.getSignatureLevel(), "SignatureLevel shall be defined within parameters!");
        Objects.requireNonNull(cmsDocument, "CMSDocument cannot be null!");
        this.assertDocumentValid(toSignDocument);
        this.assertDocumentValid(cmsDocument);
        CMSSignedData cmsSignedData = this.toCMSSignedData(cmsDocument);
        byte[] derEncodedCMS = DSSASN1Utils.getDEREncoded(cmsSignedData);
        PDFSignatureService pdfSignatureService = this.getPAdESSignatureService();
        DSSDocument signatureDocument = pdfSignatureService.sign(toSignDocument, derEncodedCMS, parameters);
        if (SignatureLevel.PAdES_BASELINE_B != parameters.getSignatureLevel() && this.isExtensionRequired(cmsSignedData, parameters)) {
            parameters.getContext().setDetachedContents(Collections.singletonList(toSignDocument));
            PAdESService padesService = this.getPAdESService();
            signatureDocument = padesService.extendDocument(signatureDocument, parameters);
        }
        signatureDocument.setName(this.getFinalDocumentName(toSignDocument, parameters.getSignatureLevel()));
        parameters.reinit();
        return signatureDocument;
    }

    private CMSSignedData toCMSSignedData(DSSDocument document) {
        try {
            return DSSUtils.toCMSSignedData(document);
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("A CMS file is expected : %s", e.getMessage()), e);
        }
    }

    protected PDFSignatureService getPAdESSignatureService() {
        return this.pdfObjFactory.newPAdESSignatureService();
    }

    protected PAdESService getPAdESService() {
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier shall be provided for PAdES extension!");
        Objects.requireNonNull(this.tspSource, "TSPSource shall be provided for PAdES extension!");
        PAdESService padesService = new PAdESService(this.certificateVerifier);
        padesService.setTspSource(this.tspSource);
        padesService.setPdfObjFactory(this.pdfObjFactory);
        return padesService;
    }

    protected String getFinalDocumentName(DSSDocument originalFile, SignatureLevel level) {
        return new FileNameBuilder().setOriginalFilename(originalFile.getName()).setSigningOperation(SigningOperation.SIGN).setSignatureLevel(level).setSignaturePackaging(SignaturePackaging.ENVELOPED).setMimeType(MimeTypeEnum.PDF).build();
    }

    private void assertDocumentValid(DSSDocument document) {
        if (document instanceof DigestDocument) {
            throw new IllegalArgumentException("DigestDocument cannot be used for PAdES!");
        }
    }

    private boolean isExtensionRequired(CMSSignedData cmsSignedData, PAdESSignatureParameters parameters) {
        if (SignatureLevel.PAdES_BASELINE_T.equals((Object)parameters.getSignatureLevel())) {
            SignerInformation signerInformation = cmsSignedData.getSignerInfos().iterator().next();
            CAdESUnsignedAttributes unsignedAttributes = CAdESUnsignedAttributes.build(signerInformation);
            for (CAdESAttribute attribute : unsignedAttributes.getAttributes()) {
                if (!PKCSObjectIdentifiers.id_aa_signatureTimeStampToken.equals(attribute.getASN1Oid())) continue;
                LOG.info("The CMS signature already contains a signature-time-stamp attribute! The extension to '%s' level is skipped.");
                return false;
            }
        }
        return true;
    }

    public boolean isValidCMSSignedData(DSSMessageDigest messageDigest, DSSDocument cms) {
        CMSSignedData cmsSignedData;
        Objects.requireNonNull(messageDigest, "messageDigest shall be provided!");
        Objects.requireNonNull(cms, "CMSSignedDocument shall be provided!");
        try {
            cmsSignedData = DSSUtils.toCMSSignedData(cms);
        }
        catch (Exception e) {
            LOG.error("Unable to decode the provided CMS document : {}", (Object)e.getMessage());
            return false;
        }
        SignerInformationStore signerInfos = cmsSignedData.getSignerInfos();
        if (signerInfos.size() != 1) {
            LOG.error("CMSSignedData shall contain one and only one SignerInformation for signature signing process!");
            return false;
        }
        CAdESSignature cadesSignature = this.toCAdESSignature(cmsSignedData, messageDigest);
        SignatureCryptographicVerification scv = cadesSignature.getSignatureCryptographicVerification();
        if (!scv.isSignatureValid()) {
            LOG.error("CMSSignedData signature is not valid!");
            return false;
        }
        return true;
    }

    public boolean isValidPAdESBaselineCMSSignedData(DSSMessageDigest messageDigest, DSSDocument cms) {
        CMSSignedData cmsSignedData;
        Objects.requireNonNull(messageDigest, "messageDigest shall be provided!");
        Objects.requireNonNull(cms, "CMSSignedDocument shall be provided!");
        try {
            cmsSignedData = DSSUtils.toCMSSignedData(cms);
        }
        catch (Exception e) {
            LOG.error("Unable to decode the provided CMS document : {}", (Object)e.getMessage());
            return false;
        }
        CAdESSignature cadeSSignature = this.toCAdESSignature(cmsSignedData, messageDigest);
        CMSForPAdESBaselineRequirementsChecker cmsRequirementsChecker = new CMSForPAdESBaselineRequirementsChecker(cadeSSignature);
        return cmsRequirementsChecker.isValidForPAdESBaselineBProfile();
    }

    private CAdESSignature toCAdESSignature(CMSSignedData cmsSignedData, DSSMessageDigest messageDigest) {
        CAdESSignature signature = new CAdESSignature(cmsSignedData, cmsSignedData.getSignerInfos().iterator().next());
        signature.setDetachedContents(Collections.singletonList(DSSUtils.toDigestDocument(messageDigest)));
        return signature;
    }
}

