/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.enumerations.SignerTextHorizontalAlignment;
import eu.europa.esig.dss.enumerations.SignerTextPosition;
import eu.europa.esig.dss.enumerations.SignerTextVerticalAlignment;
import eu.europa.esig.dss.enumerations.TextWrapping;
import eu.europa.esig.dss.pades.DSSFileFont;
import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.utils.Utils;
import java.awt.Color;
import java.io.Serializable;
import java.util.Objects;

public class SignatureImageTextParameters
implements Serializable {
    private static final long serialVersionUID = 727438728149346847L;
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    private static final float DEFAULT_PADDING = 5.0f;
    private static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    private SignerTextPosition signerTextPosition = SignerTextPosition.LEFT;
    private SignerTextVerticalAlignment signerTextVerticalAlignment = SignerTextVerticalAlignment.MIDDLE;
    private SignerTextHorizontalAlignment signerTextHorizontalAlignment = SignerTextHorizontalAlignment.LEFT;
    private String text;
    private DSSFont dssFont;
    private TextWrapping textWrapping = TextWrapping.FONT_BASED;
    private float padding = 5.0f;
    private Color textColor = DEFAULT_TEXT_COLOR;
    private Color backgroundColor = DEFAULT_BACKGROUND_COLOR;

    public SignerTextPosition getSignerTextPosition() {
        return this.signerTextPosition;
    }

    public void setSignerTextPosition(SignerTextPosition signerTextPosition) {
        this.signerTextPosition = signerTextPosition;
    }

    public SignerTextVerticalAlignment getSignerTextVerticalAlignment() {
        return this.signerTextVerticalAlignment;
    }

    public void setSignerTextVerticalAlignment(SignerTextVerticalAlignment signerTextVerticalAlignment) {
        this.signerTextVerticalAlignment = signerTextVerticalAlignment;
    }

    public SignerTextHorizontalAlignment getSignerTextHorizontalAlignment() {
        return this.signerTextHorizontalAlignment;
    }

    public void setSignerTextHorizontalAlignment(SignerTextHorizontalAlignment signerTextHorizontalAlignment) {
        this.signerTextHorizontalAlignment = signerTextHorizontalAlignment;
    }

    public DSSFont getFont() {
        if (this.dssFont == null) {
            this.dssFont = DSSFileFont.initializeDefault();
        }
        return this.dssFont;
    }

    public void setFont(DSSFont dssFont) {
        this.dssFont = dssFont;
    }

    public TextWrapping getTextWrapping() {
        return this.textWrapping;
    }

    public void setTextWrapping(TextWrapping textWrapping) {
        Objects.requireNonNull(textWrapping, "TextWrapping cannot be null!");
        this.textWrapping = textWrapping;
    }

    public float getPadding() {
        return this.padding;
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isEmpty() {
        return Utils.isStringEmpty(this.text);
    }

    public String toString() {
        return "SignatureImageTextParameters [signerTextPosition=" + (Object)((Object)this.signerTextPosition) + ", signerTextVerticalAlignment=" + (Object)((Object)this.signerTextVerticalAlignment) + ", signerTextHorizontalAlignment=" + (Object)((Object)this.signerTextHorizontalAlignment) + ", text=" + this.text + ", padding=" + this.padding + ", textColor=" + this.textColor + ", backgroundColor=" + this.backgroundColor + "]";
    }
}

