/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.x509.extension;

import eu.europa.esig.dss.enumerations.CertificateExtensionEnum;
import eu.europa.esig.dss.enumerations.OidDescription;
import eu.europa.esig.dss.model.x509.CertificateToken;

public class CertificateExtension
implements OidDescription {
    private static final long serialVersionUID = 580856406397002942L;
    private final String oid;
    private String description;
    private boolean critical;
    private byte[] octets;

    public CertificateExtension(String oid) {
        this.oid = oid;
    }

    public CertificateExtension(CertificateExtensionEnum certificateExtensionEnum) {
        this.oid = certificateExtensionEnum.getOid();
        this.description = certificateExtensionEnum.getDescription();
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void checkCritical(CertificateToken certificateToken) {
        this.critical = certificateToken.getCertificate().getCriticalExtensionOIDs().contains(this.oid);
    }

    public byte[] getOctets() {
        return this.octets;
    }

    public void setOctets(byte[] octets) {
        this.octets = octets;
    }
}

