/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.ObjectIdentifierQualifier;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.model.UserNotice;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class Policy
implements Serializable {
    private static final long serialVersionUID = 2792220193195511748L;
    private String id;
    private ObjectIdentifierQualifier qualifier;
    private String description;
    private String[] documentationReferences;
    private DigestAlgorithm digestAlgorithm;
    private byte[] digestValue;
    private String spUri;
    private UserNotice userNotice;
    private SpDocSpecification spDocSpecification;
    private boolean hashAsInTechnicalSpecification;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ObjectIdentifierQualifier getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(ObjectIdentifierQualifier qualifier) {
        this.qualifier = qualifier;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getDocumentationReferences() {
        return this.documentationReferences;
    }

    public void setDocumentationReferences(String ... documentationReferences) {
        this.documentationReferences = documentationReferences;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public byte[] getDigestValue() {
        return this.digestValue;
    }

    public void setDigestValue(byte[] digestValue) {
        this.digestValue = digestValue;
    }

    public String getSpuri() {
        return this.spUri;
    }

    public void setSpuri(String spUri) {
        this.spUri = spUri;
    }

    public UserNotice getUserNotice() {
        return this.userNotice;
    }

    public void setUserNotice(UserNotice userNotice) {
        this.userNotice = userNotice;
    }

    public SpDocSpecification getSpDocSpecification() {
        return this.spDocSpecification;
    }

    public void setSpDocSpecification(SpDocSpecification spDocSpecification) {
        this.spDocSpecification = spDocSpecification;
    }

    public boolean isHashAsInTechnicalSpecification() {
        return this.hashAsInTechnicalSpecification;
    }

    public void setHashAsInTechnicalSpecification(boolean hashAsInTechnicalSpecification) {
        this.hashAsInTechnicalSpecification = hashAsInTechnicalSpecification;
    }

    public boolean isEmpty() {
        if (this.id != null && !this.id.isEmpty()) {
            return false;
        }
        if (this.qualifier != null) {
            return false;
        }
        if (this.description != null && !this.description.isEmpty()) {
            return false;
        }
        if (this.documentationReferences != null && this.documentationReferences.length != 0) {
            return false;
        }
        if (this.digestAlgorithm != null) {
            return false;
        }
        if (this.digestValue != null && this.digestValue.length != 0) {
            return false;
        }
        if (this.spUri != null && !this.spUri.isEmpty()) {
            return false;
        }
        if (this.userNotice != null && !this.userNotice.isEmpty()) {
            return false;
        }
        if (this.spDocSpecification != null && this.spDocSpecification.getId() != null && !this.spDocSpecification.getId().isEmpty()) {
            return false;
        }
        return !this.hashAsInTechnicalSpecification;
    }

    public boolean isSPQualifierPresent() {
        if (this.spUri != null && !this.spUri.isEmpty()) {
            return true;
        }
        if (this.userNotice != null && !this.userNotice.isEmpty()) {
            return true;
        }
        return this.spDocSpecification != null && this.spDocSpecification.getId() != null && !this.spDocSpecification.getId().isEmpty();
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.documentationReferences);
        result = 31 * result + (this.digestAlgorithm != null ? this.digestAlgorithm.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.digestValue);
        result = 31 * result + (this.spUri != null ? this.spUri.hashCode() : 0);
        result = 31 * result + (this.userNotice != null ? this.userNotice.hashCode() : 0);
        result = 31 * result + (this.spDocSpecification != null ? this.spDocSpecification.hashCode() : 0);
        result = 31 * result + (this.hashAsInTechnicalSpecification ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Policy)) {
            return false;
        }
        Policy policy = (Policy)o;
        if (this.hashAsInTechnicalSpecification != policy.hashAsInTechnicalSpecification) {
            return false;
        }
        if (!Objects.equals(this.id, policy.id)) {
            return false;
        }
        if (this.qualifier != policy.qualifier) {
            return false;
        }
        if (!Objects.equals(this.description, policy.description)) {
            return false;
        }
        if (!Arrays.equals(this.documentationReferences, policy.documentationReferences)) {
            return false;
        }
        if (this.digestAlgorithm != policy.digestAlgorithm) {
            return false;
        }
        if (!Arrays.equals(this.digestValue, policy.digestValue)) {
            return false;
        }
        if (!Objects.equals(this.spUri, policy.spUri)) {
            return false;
        }
        if (!Objects.equals(this.userNotice, policy.userNotice)) {
            return false;
        }
        return Objects.equals(this.spDocSpecification, policy.spDocSpecification);
    }

    public String toString() {
        return "Policy {id='" + this.id + "', qualifier=" + (Object)((Object)this.qualifier) + ", description='" + this.description + "', documentationReferences=" + Arrays.toString(this.documentationReferences) + ", digestAlgorithm=" + this.digestAlgorithm + ", digestValue=" + Arrays.toString(this.digestValue) + ", spUri='" + this.spUri + "', userNotice=" + this.userNotice + ", spDocSpecification='" + this.spDocSpecification + "', hashAsInTechnicalSpecification=" + this.hashAsInTechnicalSpecification + "}";
    }
}

