/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KidCertificateSource
extends CommonCertificateSource {
    private static final long serialVersionUID = 8202022366337914356L;
    private static final Logger LOG = LoggerFactory.getLogger(KidCertificateSource.class);
    private Map<String, CertificateToken> mapByKid = new HashMap<String, CertificateToken>();

    @Override
    public CertificateToken addCertificate(CertificateToken certificateToAdd) {
        LOG.debug("kid is not provided (generate kid following the JAdES specification)");
        return this.addCertificate(DSSJsonUtils.generateKid(certificateToAdd), certificateToAdd);
    }

    public CertificateToken addCertificate(String kid, CertificateToken certificate) {
        CertificateToken addedCertificate = super.addCertificate(certificate);
        if (this.mapByKid.containsKey(kid)) {
            LOG.warn("kid {} is already known, the certificate will be replaced", (Object)kid);
        }
        this.mapByKid.put(kid, addedCertificate);
        return addedCertificate;
    }

    public CertificateToken getCertificateByKid(String kid) {
        return this.mapByKid.get(kid);
    }

    @Override
    protected void reset() {
        super.reset();
        this.mapByKid = new HashMap<String, CertificateToken>();
    }
}

