/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.validation.JAdESAttribute;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.validation.SignatureProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwx.Headers;

public class JAdESSignedProperties
implements SignatureProperties<JAdESAttribute> {
    private static final long serialVersionUID = 5541470950403288039L;
    private final Headers headers;

    public JAdESSignedProperties(Headers headers) {
        this.headers = headers;
    }

    @Override
    public boolean isExist() {
        return this.headers != null;
    }

    @Override
    public List<JAdESAttribute> getAttributes() {
        ArrayList<JAdESAttribute> attributes = new ArrayList<JAdESAttribute>();
        Map<String, Object> headerMap = this.getMapKeyValues();
        for (Map.Entry<String, Object> entry : headerMap.entrySet()) {
            attributes.add(new JAdESAttribute(entry.getKey(), entry.getValue()));
        }
        return attributes;
    }

    private Map<String, Object> getMapKeyValues() {
        try {
            return JsonUtil.parseJson(this.headers.getFullHeaderAsJsonString());
        }
        catch (Exception e) {
            throw new DSSException("Unable to retrieve the map from the headers", e);
        }
    }
}

