/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JWSJsonSerializationGenerator;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.signature.JAdESExtensionBuilder;
import eu.europa.esig.dss.jades.validation.AbstractJWSDocumentValidator;
import eu.europa.esig.dss.jades.validation.JAdESDocumentValidatorFactory;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESSignaturePolicyStoreBuilder
extends JAdESExtensionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESSignaturePolicyStoreBuilder.class);

    public DSSDocument addSignaturePolicyStore(DSSDocument document, SignaturePolicyStore signaturePolicyStore, boolean base64UrlInstance) {
        Objects.requireNonNull(document, "Signature document must be provided!");
        this.assertConfigurationValid(signaturePolicyStore);
        AbstractJWSDocumentValidator documentValidator = this.getDocumentValidator(document);
        JWSJsonSerializationObject jwsJsonSerializationObject = documentValidator.getJwsJsonSerializationObject();
        this.assertJSONSerializationObjectMayBeExtended(jwsJsonSerializationObject);
        List<AdvancedSignature> signatures = documentValidator.getSignatures();
        boolean signaturePolicyStoreAdded = false;
        for (AdvancedSignature signature : signatures) {
            boolean added = this.addSignaturePolicyStoreIfDigestMatch((JAdESSignature)signature, signaturePolicyStore, base64UrlInstance, documentValidator);
            signaturePolicyStoreAdded = signaturePolicyStoreAdded || added;
        }
        if (!signaturePolicyStoreAdded) {
            throw new IllegalInputException("The process did not find a signature to add SignaturePolicyStore!");
        }
        JWSJsonSerializationGenerator generator = new JWSJsonSerializationGenerator(jwsJsonSerializationObject, jwsJsonSerializationObject.getJWSSerializationType());
        return generator.generate();
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument document, SignaturePolicyStore signaturePolicyStore, boolean base64UrlInstance, String signatureId) {
        Objects.requireNonNull(document, "Signature document must be provided!");
        this.assertConfigurationValid(signaturePolicyStore);
        AbstractJWSDocumentValidator documentValidator = this.getDocumentValidator(document);
        JWSJsonSerializationObject jwsJsonSerializationObject = documentValidator.getJwsJsonSerializationObject();
        this.assertJSONSerializationObjectMayBeExtended(jwsJsonSerializationObject);
        AdvancedSignature signature = documentValidator.getSignatureById(signatureId);
        if (signature == null) {
            throw new IllegalInputException(String.format("Unable to find a signature with Id : %s!", signatureId));
        }
        boolean added = this.addSignaturePolicyStoreIfDigestMatch((JAdESSignature)signature, signaturePolicyStore, base64UrlInstance, documentValidator);
        if (!added) {
            throw new IllegalInputException(String.format("The process was not able to add SignaturePolicyStore to a signature with Id : %s!", signatureId));
        }
        JWSJsonSerializationGenerator generator = new JWSJsonSerializationGenerator(jwsJsonSerializationObject, jwsJsonSerializationObject.getJWSSerializationType());
        return generator.generate();
    }

    protected boolean addSignaturePolicyStoreIfDigestMatch(JAdESSignature jadesSignature, SignaturePolicyStore signaturePolicyStore, boolean base64UrlInstance, SignedDocumentValidator documentValidator) {
        this.assertEtsiUComponentsConsistent(jadesSignature.getJws(), base64UrlInstance);
        if (this.checkDigest(jadesSignature, signaturePolicyStore, documentValidator)) {
            String sigPolDocLocalURI;
            LinkedHashMap<String, Object> sigPolicyStoreParams = new LinkedHashMap<String, Object>();
            DSSDocument signaturePolicyContent = signaturePolicyStore.getSignaturePolicyContent();
            if (signaturePolicyContent != null) {
                sigPolicyStoreParams.put("sigPolDoc", Utils.toBase64(DSSUtils.toByteArray(signaturePolicyContent)));
            }
            if (Utils.isStringNotEmpty(sigPolDocLocalURI = signaturePolicyStore.getSigPolDocLocalURI())) {
                sigPolicyStoreParams.put("sigPolLocalURI", sigPolDocLocalURI);
            }
            SpDocSpecification spDocSpecification = signaturePolicyStore.getSpDocSpecification();
            JsonObject oidObject = DSSJsonUtils.getOidObject(spDocSpecification.getId(), spDocSpecification.getDescription(), spDocSpecification.getDocumentationReferences());
            sigPolicyStoreParams.put("spDSpec", oidObject);
            JAdESEtsiUHeader etsiUHeader = jadesSignature.getEtsiUHeader();
            etsiUHeader.addComponent("sigPSt", sigPolicyStoreParams, base64UrlInstance);
            return true;
        }
        return false;
    }

    protected boolean checkDigest(JAdESSignature jadesSignature, SignaturePolicyStore signaturePolicyStore, SignedDocumentValidator documentValidator) {
        SignaturePolicy signaturePolicy = jadesSignature.getSignaturePolicy();
        if (signaturePolicy == null) {
            LOG.warn("No defined SignaturePolicyIdentifier for signature with Id : {}", (Object)jadesSignature.getId());
            return false;
        }
        Digest expectedDigest = signaturePolicy.getDigest();
        if (expectedDigest == null) {
            LOG.warn("No defined digest for signature with Id : {}", (Object)jadesSignature.getId());
            return false;
        }
        DSSDocument signaturePolicyContent = signaturePolicyStore.getSignaturePolicyContent();
        if (signaturePolicyContent == null) {
            LOG.info("No policy document has been provided. Digests are not checked!");
            return true;
        }
        signaturePolicy.setPolicyContent(signaturePolicyContent);
        SignaturePolicyValidator validator = documentValidator.getSignaturePolicyValidatorLoader().loadValidator(signaturePolicy);
        Digest computedDigest = validator.getComputedDigest(signaturePolicyContent, expectedDigest.getAlgorithm());
        boolean digestMatch = expectedDigest.equals(computedDigest);
        if (!digestMatch) {
            LOG.warn("Signature policy's digest {} doesn't match the digest extracted from document {} for signature with Id : {}", computedDigest, expectedDigest, jadesSignature.getId());
        }
        return digestMatch;
    }

    private AbstractJWSDocumentValidator getDocumentValidator(DSSDocument document) {
        JAdESDocumentValidatorFactory documentValidatorFactory = new JAdESDocumentValidatorFactory();
        return documentValidatorFactory.create(document);
    }

    private void assertConfigurationValid(SignaturePolicyStore signaturePolicyStore) {
        boolean sigPolDocLocalURIPresent;
        Objects.requireNonNull(signaturePolicyStore, "SignaturePolicyStore must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification(), "SpDocSpecification must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification().getId(), "ID (OID or URI) for SpDocSpecification must be provided");
        boolean signaturePolicyContentPresent = signaturePolicyStore.getSignaturePolicyContent() != null;
        boolean bl = sigPolDocLocalURIPresent = signaturePolicyStore.getSigPolDocLocalURI() != null;
        if (!(signaturePolicyContentPresent ^ sigPolDocLocalURIPresent)) {
            throw new IllegalArgumentException("SignaturePolicyStore shall contain either SignaturePolicyContent document or sigPolDocLocalURI!");
        }
    }
}

