/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.enumerations.SigDMechanism;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.JAdESTimestampParameters;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.signature.HttpHeadersPayloadBuilder;
import eu.europa.esig.dss.jades.signature.JAdESBuilder;
import eu.europa.esig.dss.jades.signature.JAdESCompactBuilder;
import eu.europa.esig.dss.jades.signature.JAdESCounterSignatureBuilder;
import eu.europa.esig.dss.jades.signature.JAdESCounterSignatureParameters;
import eu.europa.esig.dss.jades.signature.JAdESLevelBaselineExtension;
import eu.europa.esig.dss.jades.signature.JAdESLevelBaselineLT;
import eu.europa.esig.dss.jades.signature.JAdESLevelBaselineLTA;
import eu.europa.esig.dss.jades.signature.JAdESLevelBaselineT;
import eu.europa.esig.dss.jades.signature.JAdESSerializationBuilder;
import eu.europa.esig.dss.jades.signature.JAdESSignaturePolicyStoreBuilder;
import eu.europa.esig.dss.jades.validation.AbstractJWSDocumentValidator;
import eu.europa.esig.dss.jades.validation.JAdESDocumentValidatorFactory;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.CounterSignatureService;
import eu.europa.esig.dss.signature.MultipleDocumentsSignatureService;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DSSPKUtils;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.tsp.TSPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESService
extends AbstractSignatureService<JAdESSignatureParameters, JAdESTimestampParameters>
implements MultipleDocumentsSignatureService<JAdESSignatureParameters, JAdESTimestampParameters>,
CounterSignatureService<JAdESCounterSignatureParameters> {
    private static final long serialVersionUID = -7057603783915654317L;
    private static final Logger LOG = LoggerFactory.getLogger(JAdESService.class);

    public JAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ JAdESService created");
    }

    @Override
    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, JAdESSignatureParameters parameters) {
        return this.getContentTimestamp(Arrays.asList(toSignDocument), parameters);
    }

    @Override
    public TimestampToken getContentTimestamp(List<DSSDocument> toSignDocuments, JAdESSignatureParameters parameters) {
        byte[] messageImprint;
        Objects.requireNonNull(this.tspSource, "A TSPSource is required!");
        this.assertContentTimestampCreationPossible(toSignDocuments);
        if (SigDMechanism.HTTP_HEADERS.equals(parameters.getSigDMechanism())) {
            HttpHeadersPayloadBuilder httpHeadersPayloadBuilder = new HttpHeadersPayloadBuilder(toSignDocuments, true);
            messageImprint = httpHeadersPayloadBuilder.build();
        } else {
            messageImprint = DSSJsonUtils.concatenateDSSDocuments(toSignDocuments, parameters.isBase64UrlEncodedPayload());
        }
        DigestAlgorithm digestAlgorithm = parameters.getContentTimestampParameters().getDigestAlgorithm();
        TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, DSSUtils.digest(digestAlgorithm, messageImprint));
        try {
            return new TimestampToken(timeStampResponse.getBytes(), TimestampType.CONTENT_TIMESTAMP);
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException("Cannot create a content TimestampToken", e);
        }
    }

    private void assertContentTimestampCreationPossible(List<DSSDocument> documents) {
        if (Utils.isCollectionEmpty(documents)) {
            throw new IllegalArgumentException("Original documents must be provided to generate a content timestamp!");
        }
        for (DSSDocument document : documents) {
            if (!(document instanceof DigestDocument)) continue;
            throw new IllegalArgumentException("Content timestamp creation is not possible with DigestDocument!");
        }
    }

    @Override
    public ToBeSigned getDataToSign(DSSDocument toSignDocument, JAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSigningCertificateValid(parameters);
        JAdESBuilder jadesBuilder = this.getJAdESBuilder(parameters, Collections.singletonList(toSignDocument));
        return jadesBuilder.buildDataToBeSigned();
    }

    @Override
    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, JAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocuments, "toSignDocuments cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertMultiDocumentsAllowed(toSignDocuments, parameters);
        this.assertSigningCertificateValid(parameters);
        JAdESBuilder jadesBuilder = this.getJAdESBuilder(parameters, toSignDocuments);
        return jadesBuilder.buildDataToBeSigned();
    }

    private void assertMultiDocumentsAllowed(List<DSSDocument> toSignDocuments, JAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters.getSignaturePackaging(), "SignaturePackaging shall be defined!");
        if (Utils.isCollectionEmpty(toSignDocuments)) {
            throw new IllegalArgumentException("The documents to sign must be provided!");
        }
        SignaturePackaging signaturePackaging = parameters.getSignaturePackaging();
        if (!SignaturePackaging.DETACHED.equals((Object)signaturePackaging) && toSignDocuments.size() > 1) {
            throw new IllegalArgumentException("Not supported operation (only DETACHED are allowed for multiple document signing)!");
        }
        if (SignaturePackaging.DETACHED.equals((Object)signaturePackaging) && SigDMechanism.NO_SIG_D.equals(parameters.getSigDMechanism()) && toSignDocuments.size() > 1) {
            throw new IllegalArgumentException("NO_SIG_D mechanism is not allowed for multiple documents!");
        }
    }

    @Override
    public DSSDocument signDocument(DSSDocument toSignDocument, JAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        return this.signDocument(Collections.singletonList(toSignDocument), parameters, signatureValue);
    }

    @Override
    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, JAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocuments, "toSignDocuments cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        this.assertMultiDocumentsAllowed(toSignDocuments, parameters);
        this.assertSigningCertificateValid(parameters);
        JAdESBuilder jadesBuilder = this.getJAdESBuilder(parameters, toSignDocuments);
        DSSDocument signedDocument = jadesBuilder.build(signatureValue);
        JAdESLevelBaselineExtension signatureExtension = this.getExtensionProfile(parameters);
        if (signatureExtension != null) {
            if (SignaturePackaging.DETACHED.equals((Object)parameters.getSignaturePackaging()) && Utils.isCollectionEmpty(parameters.getDetachedContents())) {
                parameters.getContext().setDetachedContents(toSignDocuments);
            }
            signatureExtension.setOperationKind(SigningOperation.SIGN);
            signedDocument = signatureExtension.extendSignatures(signedDocument, parameters);
        }
        parameters.reinit();
        signedDocument.setName(this.getFinalFileName(toSignDocuments.iterator().next(), SigningOperation.SIGN, parameters.getSignatureLevel()));
        signedDocument.setMimeType(jadesBuilder.getMimeType());
        return signedDocument;
    }

    protected JAdESBuilder getJAdESBuilder(JAdESSignatureParameters parameters, List<DSSDocument> documentsToSign) {
        JWSJsonSerializationObject jwsJsonSerializationObject = this.getJWSJsonSerializationObjectToSign(documentsToSign);
        if (this.containsSignatures(jwsJsonSerializationObject)) {
            if (!jwsJsonSerializationObject.isValid()) {
                throw new IllegalInputException(String.format("Parallel signing is not supported for invalid RFC 7515 signatures. Reason(s) : %s", jwsJsonSerializationObject.getStructuralValidationErrors()));
            }
            return new JAdESSerializationBuilder(this.certificateVerifier, parameters, jwsJsonSerializationObject);
        }
        switch (parameters.getJwsSerializationType()) {
            case COMPACT_SERIALIZATION: {
                return new JAdESCompactBuilder(this.certificateVerifier, parameters, documentsToSign);
            }
            case JSON_SERIALIZATION: 
            case FLATTENED_JSON_SERIALIZATION: {
                return new JAdESSerializationBuilder(this.certificateVerifier, parameters, documentsToSign);
            }
        }
        throw new DSSException(String.format("The requested JWS Serialization Type '%s' is not supported!", new Object[]{parameters.getJwsSerializationType()}));
    }

    private JWSJsonSerializationObject getJWSJsonSerializationObjectToSign(List<DSSDocument> documentsToSign) {
        DSSDocument document;
        JAdESDocumentValidatorFactory documentValidatorFactory;
        if (Utils.isCollectionNotEmpty(documentsToSign) && documentsToSign.size() == 1 && (documentValidatorFactory = new JAdESDocumentValidatorFactory()).isSupported(document = documentsToSign.get(0))) {
            AbstractJWSDocumentValidator documentValidator = documentValidatorFactory.create(document);
            return documentValidator.getJwsJsonSerializationObject();
        }
        return null;
    }

    private boolean containsSignatures(JWSJsonSerializationObject jwsJsonSerializationObject) {
        return jwsJsonSerializationObject != null && Utils.isCollectionNotEmpty(jwsJsonSerializationObject.getSignatures());
    }

    @Override
    public DSSDocument extendDocument(DSSDocument toExtendDocument, JAdESSignatureParameters parameters) {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument cannot be null!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        Objects.requireNonNull(parameters.getSignatureLevel(), "SignatureLevel must be defined!");
        this.assertExtensionPossible(parameters);
        JAdESLevelBaselineExtension signatureExtension = this.getExtensionProfile(parameters);
        if (signatureExtension != null) {
            signatureExtension.setOperationKind(SigningOperation.EXTEND);
            DSSDocument dssDocument = signatureExtension.extendSignatures(toExtendDocument, parameters);
            dssDocument.setName(this.getFinalFileName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel()));
            dssDocument.setMimeType(MimeTypeEnum.JOSE_JSON);
            return dssDocument;
        }
        throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", new Object[]{parameters.getSignatureLevel()}));
    }

    private void assertExtensionPossible(JAdESSignatureParameters parameters) {
        if (!JWSSerializationType.JSON_SERIALIZATION.equals((Object)parameters.getJwsSerializationType()) && !JWSSerializationType.FLATTENED_JSON_SERIALIZATION.equals((Object)parameters.getJwsSerializationType())) {
            throw new IllegalArgumentException(String.format("The type '%s' does not support signature extension!", new Object[]{parameters.getJwsSerializationType()}));
        }
    }

    private JAdESLevelBaselineExtension getExtensionProfile(JAdESSignatureParameters parameters) {
        switch (parameters.getSignatureLevel()) {
            case JAdES_BASELINE_B: {
                return null;
            }
            case JAdES_BASELINE_T: {
                JAdESLevelBaselineT extensionT = new JAdESLevelBaselineT(this.certificateVerifier);
                extensionT.setTspSource(this.tspSource);
                return extensionT;
            }
            case JAdES_BASELINE_LT: {
                JAdESLevelBaselineLT extensionLT = new JAdESLevelBaselineLT(this.certificateVerifier);
                extensionLT.setTspSource(this.tspSource);
                return extensionLT;
            }
            case JAdES_BASELINE_LTA: {
                JAdESLevelBaselineLTA extensionLTA = new JAdESLevelBaselineLTA(this.certificateVerifier);
                extensionLTA.setTspSource(this.tspSource);
                return extensionLTA;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", new Object[]{parameters.getSignatureLevel()}));
    }

    @Override
    public DSSDocument timestamp(List<DSSDocument> toTimestampDocuments, JAdESTimestampParameters parameters) {
        throw new UnsupportedOperationException("Unsupported operation for this file format");
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument document, SignaturePolicyStore signaturePolicyStore) {
        return this.addSignaturePolicyStore(document, signaturePolicyStore, true);
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument document, SignaturePolicyStore signaturePolicyStore, boolean base64UrlInstance) {
        Objects.requireNonNull(document, "The document cannot be null");
        Objects.requireNonNull(signaturePolicyStore, "The signaturePolicyStore cannot be null");
        JAdESSignaturePolicyStoreBuilder builder = new JAdESSignaturePolicyStoreBuilder();
        DSSDocument signatureWithPolicyStore = builder.addSignaturePolicyStore(document, signaturePolicyStore, base64UrlInstance);
        signatureWithPolicyStore.setName(this.getFinalFileName(document, SigningOperation.ADD_SIG_POLICY_STORE));
        signatureWithPolicyStore.setMimeType(document.getMimeType());
        return signatureWithPolicyStore;
    }

    @Override
    public ToBeSigned getDataToBeCounterSigned(DSSDocument signatureDocument, JAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(signatureDocument, "signatureDocument cannot be null!");
        this.verifyAndSetCounterSignatureParameters(parameters);
        this.assertSigningCertificateValid(parameters);
        JAdESCounterSignatureBuilder counterSignatureBuilder = new JAdESCounterSignatureBuilder();
        DSSDocument signatureValueToSign = counterSignatureBuilder.getSignatureValueToBeSigned(signatureDocument, parameters);
        return this.getDataToSign(signatureValueToSign, (JAdESSignatureParameters)parameters);
    }

    @Override
    public DSSDocument counterSignSignature(DSSDocument signatureDocument, JAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(signatureDocument, "signatureDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "signatureValue cannot be null!");
        this.verifyAndSetCounterSignatureParameters(parameters);
        this.assertSigningCertificateValid(parameters);
        JAdESCounterSignatureBuilder counterSignatureBuilder = new JAdESCounterSignatureBuilder();
        DSSDocument signatureValueToSign = counterSignatureBuilder.getSignatureValueToBeSigned(signatureDocument, parameters);
        DSSDocument counterSignature = this.signDocument(signatureValueToSign, (JAdESSignatureParameters)parameters, signatureValue);
        DSSDocument counterSigned = counterSignatureBuilder.buildEmbeddedCounterSignature(signatureDocument, counterSignature, parameters);
        parameters.reinit();
        counterSigned.setName(this.getFinalFileName(signatureDocument, SigningOperation.COUNTER_SIGN, parameters.getSignatureLevel()));
        counterSigned.setMimeType(signatureDocument.getMimeType());
        return counterSigned;
    }

    private void verifyAndSetCounterSignatureParameters(JAdESCounterSignatureParameters parameters) {
        if (parameters.getSignaturePackaging() == null) {
            parameters.setSignaturePackaging(SignaturePackaging.ENVELOPING);
        }
        switch (parameters.getSignaturePackaging()) {
            case ENVELOPING: {
                break;
            }
            case DETACHED: {
                if (parameters.getSigDMechanism() == null) {
                    parameters.setSigDMechanism(SigDMechanism.NO_SIG_D);
                    break;
                }
                if (SigDMechanism.NO_SIG_D.equals(parameters.getSigDMechanism())) break;
                throw new IllegalArgumentException(String.format("The SigDMechanism '%s' is not supported by JAdES Counter Signature!", parameters.getSigDMechanism()));
            }
            default: {
                throw new IllegalArgumentException(String.format("The SignaturePackaging '%s' is not supported by JAdES Counter Signature!", new Object[]{parameters.getSignaturePackaging()}));
            }
        }
        if (JWSSerializationType.JSON_SERIALIZATION.equals((Object)parameters.getJwsSerializationType())) {
            throw new IllegalArgumentException("The JWSSerializationType.JSON_SERIALIZATION parameter is not supported for a JAdES Counter Signature!");
        }
    }

    @Override
    public boolean isValidSignatureValue(ToBeSigned toBeSigned, SignatureValue signatureValue, CertificateToken signingCertificate) {
        if (!super.isValidSignatureValue(toBeSigned, signatureValue, signingCertificate)) {
            return false;
        }
        try {
            this.assertSigningCertificateValid(signatureValue.getAlgorithm(), signingCertificate);
            this.assertSignatureValueValid(signatureValue.getAlgorithm(), signatureValue);
            return true;
        }
        catch (Exception e) {
            LOG.error("Invalid signature value : {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    protected void assertSigningCertificateValid(AbstractSignatureParameters<?> parameters) {
        super.assertSigningCertificateValid(parameters);
        this.assertSigningCertificateValid(parameters.getSignatureAlgorithm(), parameters.getSigningCertificate());
    }

    private void assertSigningCertificateValid(SignatureAlgorithm signatureAlgorithm, CertificateToken signingCertificate) {
        if (signatureAlgorithm.getEncryptionAlgorithm() != null && signatureAlgorithm.getDigestAlgorithm() != null && signatureAlgorithm.getEncryptionAlgorithm().isEquivalent(EncryptionAlgorithm.ECDSA) && signingCertificate != null) {
            String errorMessage = "For ECDSA with %s a key with P-%s curve shall be used for a JWS! See RFC 7518.";
            int keySize = DSSPKUtils.getPublicKeySize(signingCertificate.getPublicKey());
            switch (signatureAlgorithm.getDigestAlgorithm()) {
                case SHA256: {
                    if (256 == keySize) break;
                    throw new IllegalArgumentException(String.format(errorMessage, signatureAlgorithm.getDigestAlgorithm(), 256));
                }
                case SHA384: {
                    if (384 == keySize) break;
                    throw new IllegalArgumentException(String.format(errorMessage, signatureAlgorithm.getDigestAlgorithm(), 384));
                }
                case SHA512: {
                    if (521 == keySize) break;
                    throw new IllegalArgumentException(String.format(errorMessage, signatureAlgorithm.getDigestAlgorithm(), 521));
                }
                default: {
                    throw new UnsupportedOperationException(String.format("ECDSA with %s is not supported for JWS!", signatureAlgorithm.getDigestAlgorithm()));
                }
            }
        }
    }

    private void assertSignatureValueValid(SignatureAlgorithm targetSignatureAlgorithm, SignatureValue signatureValue) {
        if (targetSignatureAlgorithm.getEncryptionAlgorithm().isEquivalent(EncryptionAlgorithm.ECDSA)) {
            String errorMessage = "Invalid SignatureValue obtained! For ECDSA with %s a key with P-%s curve shall be used for a JWS. See RFC 7518.";
            int bitLength = DSSASN1Utils.getSignatureValueBitLength(signatureValue.getValue());
            switch (targetSignatureAlgorithm.getDigestAlgorithm()) {
                case SHA256: {
                    if (bitLength == 256) break;
                    throw new IllegalInputException(String.format(errorMessage, targetSignatureAlgorithm.getDigestAlgorithm(), 256));
                }
                case SHA384: {
                    if (bitLength == 384) break;
                    throw new IllegalArgumentException(String.format(errorMessage, targetSignatureAlgorithm.getDigestAlgorithm(), 384));
                }
                case SHA512: {
                    if (bitLength == 520 || bitLength == 528) break;
                    throw new IllegalArgumentException(String.format(errorMessage, targetSignatureAlgorithm.getDigestAlgorithm(), 521));
                }
                default: {
                    throw new UnsupportedOperationException(String.format("ECDSA with %s is not supported for JWS!", targetSignatureAlgorithm.getDigestAlgorithm()));
                }
            }
        }
    }
}

