/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

public enum TokenExtractionStrategy {
    EXTRACT_ALL(true, true, true),
    EXTRACT_CERTIFICATES_ONLY(true, false, false),
    EXTRACT_TIMESTAMPS_ONLY(false, true, false),
    EXTRACT_REVOCATION_DATA_ONLY(false, false, true),
    EXTRACT_CERTIFICATES_AND_TIMESTAMPS(true, true, false),
    EXTRACT_CERTIFICATES_AND_REVOCATION_DATA(true, false, true),
    EXTRACT_TIMESTAMPS_AND_REVOCATION_DATA(false, true, true),
    NONE(false, false, false);

    private final boolean certificate;
    private final boolean timestamp;
    private final boolean revocationData;

    private TokenExtractionStrategy(boolean certificate, boolean timestamp, boolean revocationData) {
        this.certificate = certificate;
        this.timestamp = timestamp;
        this.revocationData = revocationData;
    }

    public boolean isCertificate() {
        return this.certificate;
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public boolean isRevocationData() {
        return this.revocationData;
    }

    public static TokenExtractionStrategy fromParameters(boolean certificate, boolean timestamp, boolean revocationData) {
        for (TokenExtractionStrategy value : TokenExtractionStrategy.values()) {
            if (certificate != value.certificate || timestamp != value.timestamp || revocationData != value.revocationData) continue;
            return value;
        }
        return NONE;
    }
}

