/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

public enum TimestampType {
    CONTENT_TIMESTAMP(0, false),
    ALL_DATA_OBJECTS_TIMESTAMP(0, false),
    INDIVIDUAL_DATA_OBJECTS_TIMESTAMP(0, false),
    SIGNATURE_TIMESTAMP(1, true),
    VRI_TIMESTAMP(1, true),
    VALIDATION_DATA_REFSONLY_TIMESTAMP(2, false),
    VALIDATION_DATA_TIMESTAMP(2, true),
    DOCUMENT_TIMESTAMP(3, true),
    ARCHIVE_TIMESTAMP(3, true);

    private final Integer order;
    private final boolean coversSignature;

    private TimestampType(int order, boolean coversSignature) {
        this.order = order;
        this.coversSignature = coversSignature;
    }

    public boolean isContentTimestamp() {
        return 0 == this.order;
    }

    public boolean isSignatureTimestamp() {
        return 1 == this.order;
    }

    public boolean isValidationDataTimestamp() {
        return 2 == this.order;
    }

    public boolean isDocumentTimestamp() {
        return DOCUMENT_TIMESTAMP == this;
    }

    public boolean isArchivalTimestamp() {
        return ARCHIVE_TIMESTAMP == this;
    }

    public boolean coversSignature() {
        return this.coversSignature;
    }

    public int compare(TimestampType timestampType) {
        return this.order.compareTo(timestampType.order);
    }
}

