/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.DistinguishedNameListWrapper;
import eu.europa.esig.dss.diagnostic.PSD2InfoWrapper;
import eu.europa.esig.dss.diagnostic.QCLimitValueWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlAuthorityInformationAccess;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicConstraints;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCRLDistributionPoints;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateContentEquivalence;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateExtension;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificatePolicies;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificatePolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlExtendedKeyUsages;
import eu.europa.esig.dss.diagnostic.jaxb.XmlGeneralName;
import eu.europa.esig.dss.diagnostic.jaxb.XmlGeneralSubtree;
import eu.europa.esig.dss.diagnostic.jaxb.XmlIdPkixOcspNoCheck;
import eu.europa.esig.dss.diagnostic.jaxb.XmlInhibitAnyPolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlKeyUsages;
import eu.europa.esig.dss.diagnostic.jaxb.XmlLangAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlMRATrustServiceMapping;
import eu.europa.esig.dss.diagnostic.jaxb.XmlNameConstraints;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOriginalThirdCountryQcStatementsMapping;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOriginalThirdCountryTrustedServiceMapping;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicyConstraints;
import eu.europa.esig.dss.diagnostic.jaxb.XmlQcStatements;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSubjectAlternativeNames;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSubjectKeyIdentifier;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedService;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedServiceProvider;
import eu.europa.esig.dss.diagnostic.jaxb.XmlValAssuredShortTermCertificate;
import eu.europa.esig.dss.enumerations.CertificateExtensionEnum;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.ExtendedKeyUsage;
import eu.europa.esig.dss.enumerations.KeyUsageBit;
import eu.europa.esig.dss.enumerations.QCType;
import eu.europa.esig.dss.enumerations.SemanticsIdentifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CertificateWrapper
extends AbstractTokenProxy {
    private final XmlCertificate certificate;

    public CertificateWrapper(XmlCertificate certificate) {
        Objects.requireNonNull(certificate, "XMLCertificate cannot be null!");
        this.certificate = certificate;
    }

    @Override
    public String getId() {
        return this.certificate.getId();
    }

    @Override
    protected XmlBasicSignature getCurrentBasicSignature() {
        return this.certificate.getBasicSignature();
    }

    @Override
    protected List<XmlChainItem> getCurrentCertificateChain() {
        return this.certificate.getCertificateChain();
    }

    @Override
    protected XmlSigningCertificate getCurrentSigningCertificate() {
        return this.certificate.getSigningCertificate();
    }

    public boolean isTrusted() {
        return this.certificate.isTrusted();
    }

    public boolean isSelfSigned() {
        return this.certificate.isSelfSigned();
    }

    public List<XmlCertificateExtension> getCertificateExtensions() {
        return new ArrayList<XmlCertificateExtension>(this.certificate.getCertificateExtensions());
    }

    public <T extends XmlCertificateExtension> T getCertificateExtensionForOid(String oid, Class<T> targetClass) {
        for (XmlCertificateExtension certificateExtension : this.getCertificateExtensions()) {
            if (!oid.equals(certificateExtension.getOID())) continue;
            if (targetClass.isInstance(certificateExtension)) {
                return (T)certificateExtension;
            }
            throw new UnsupportedOperationException(String.format("A certificate extension with OID '%s' shall be in instance of '%s' class!", oid, targetClass.getName()));
        }
        return null;
    }

    public List<XmlGeneralName> getSubjectAlternativeNames() {
        XmlSubjectAlternativeNames subjectAlternativeNames = this.getXmlSubjectAlternativeNames();
        return subjectAlternativeNames != null ? subjectAlternativeNames.getSubjectAlternativeName() : Collections.emptyList();
    }

    private XmlSubjectAlternativeNames getXmlSubjectAlternativeNames() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.SUBJECT_ALTERNATIVE_NAME.getOid(), XmlSubjectAlternativeNames.class);
    }

    public boolean isCA() {
        XmlBasicConstraints basicConstraints = this.getXmlBasicConstraints();
        return basicConstraints != null && basicConstraints.isCA();
    }

    public int getPathLenConstraint() {
        XmlBasicConstraints basicConstraints = this.getXmlBasicConstraints();
        return basicConstraints != null && basicConstraints.isCA() && basicConstraints.getPathLenConstraint() != null ? basicConstraints.getPathLenConstraint() : -1;
    }

    private XmlBasicConstraints getXmlBasicConstraints() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.BASIC_CONSTRAINTS.getOid(), XmlBasicConstraints.class);
    }

    public int getRequireExplicitPolicy() {
        XmlPolicyConstraints policyConstraints = this.getXmlPolicyConstraints();
        return policyConstraints != null && policyConstraints.getRequireExplicitPolicy() != null ? policyConstraints.getRequireExplicitPolicy() : -1;
    }

    public int getInhibitPolicyMapping() {
        XmlPolicyConstraints policyConstraints = this.getXmlPolicyConstraints();
        return policyConstraints != null && policyConstraints.getInhibitPolicyMapping() != null ? policyConstraints.getInhibitPolicyMapping() : -1;
    }

    private XmlPolicyConstraints getXmlPolicyConstraints() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.POLICY_CONSTRAINTS.getOid(), XmlPolicyConstraints.class);
    }

    public int getInhibitAnyPolicy() {
        XmlInhibitAnyPolicy inhibitAnyPolicy = this.getXmlInhibitAnyPolicy();
        return inhibitAnyPolicy != null && inhibitAnyPolicy.getValue() != null ? inhibitAnyPolicy.getValue() : -1;
    }

    private XmlInhibitAnyPolicy getXmlInhibitAnyPolicy() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.INHIBIT_ANY_POLICY.getOid(), XmlInhibitAnyPolicy.class);
    }

    public List<XmlGeneralSubtree> getPermittedSubtrees() {
        XmlNameConstraints nameConstraints = this.getXmlNameConstraints();
        return nameConstraints != null ? nameConstraints.getPermittedSubtrees() : Collections.emptyList();
    }

    public List<XmlGeneralSubtree> getExcludedSubtrees() {
        XmlNameConstraints nameConstraints = this.getXmlNameConstraints();
        return nameConstraints != null ? nameConstraints.getExcludedSubtrees() : Collections.emptyList();
    }

    private XmlNameConstraints getXmlNameConstraints() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.NAME_CONSTRAINTS.getOid(), XmlNameConstraints.class);
    }

    public List<KeyUsageBit> getKeyUsages() {
        XmlKeyUsages keyUsage = this.getXmlKeyUsage();
        return keyUsage != null ? keyUsage.getKeyUsageBit() : Collections.emptyList();
    }

    private XmlKeyUsages getXmlKeyUsage() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.KEY_USAGE.getOid(), XmlKeyUsages.class);
    }

    public boolean isRevocationDataAvailable() {
        return this.certificate.getRevocations() != null && !this.certificate.getRevocations().isEmpty();
    }

    public List<CertificateSourceType> getSources() {
        return this.certificate.getSources();
    }

    public List<CertificateRevocationWrapper> getCertificateRevocationData() {
        ArrayList<CertificateRevocationWrapper> certRevocationWrappers = new ArrayList<CertificateRevocationWrapper>();
        List<XmlCertificateRevocation> revocations = this.certificate.getRevocations();
        for (XmlCertificateRevocation xmlCertificateRevocation : revocations) {
            certRevocationWrappers.add(new CertificateRevocationWrapper(xmlCertificateRevocation));
        }
        return certRevocationWrappers;
    }

    public CertificateRevocationWrapper getRevocationDataById(String revocationId) {
        for (CertificateRevocationWrapper revocationData : this.getCertificateRevocationData()) {
            if (!revocationId.equals(revocationData.getId())) continue;
            return revocationData;
        }
        return null;
    }

    public boolean isIdPkixOcspNoCheck() {
        XmlIdPkixOcspNoCheck ocspNoCheck = this.getXmlIdPkixOcspNoCheck();
        return ocspNoCheck != null && ocspNoCheck.isPresent() != false;
    }

    private XmlIdPkixOcspNoCheck getXmlIdPkixOcspNoCheck() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.OCSP_NOCHECK.getOid(), XmlIdPkixOcspNoCheck.class);
    }

    public boolean isIdKpOCSPSigning() {
        XmlExtendedKeyUsages extendedKeyUsage = this.getXmlExtendedKeyUsages();
        if (extendedKeyUsage != null) {
            for (XmlOID xmlOID : extendedKeyUsage.getExtendedKeyUsageOid()) {
                if (!ExtendedKeyUsage.OCSP_SIGNING.getOid().equals(xmlOID.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValAssuredShortTermCertificate() {
        XmlValAssuredShortTermCertificate valAssuredShortTermCertificate = this.getXmlValAssuredShortTermCertificate();
        return valAssuredShortTermCertificate != null && valAssuredShortTermCertificate.isPresent() != false;
    }

    private XmlValAssuredShortTermCertificate getXmlValAssuredShortTermCertificate() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.VALIDITY_ASSURED_SHORT_TERM.getOid(), XmlValAssuredShortTermCertificate.class);
    }

    public List<XmlOID> getExtendedKeyUsages() {
        XmlExtendedKeyUsages extendedKeyUsage = this.getXmlExtendedKeyUsages();
        return extendedKeyUsage != null ? extendedKeyUsage.getExtendedKeyUsageOid() : Collections.emptyList();
    }

    private XmlExtendedKeyUsages getXmlExtendedKeyUsages() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.EXTENDED_KEY_USAGE.getOid(), XmlExtendedKeyUsages.class);
    }

    public Date getNotBefore() {
        return this.certificate.getNotBefore();
    }

    public Date getNotAfter() {
        return this.certificate.getNotAfter();
    }

    public String getEntityKey() {
        return this.certificate.getEntityKey();
    }

    public Date getCertificateTSPServiceExpiredCertsRevocationInfo() {
        List<XmlTrustedServiceProvider> trustedServiceProviders = this.certificate.getTrustedServiceProviders();
        if (trustedServiceProviders != null) {
            for (XmlTrustedServiceProvider trustedServiceProvider : trustedServiceProviders) {
                List<XmlTrustedService> trustedServices = trustedServiceProvider.getTrustedServices();
                for (XmlTrustedService xmlTrustedService : trustedServices) {
                    if (xmlTrustedService.getExpiredCertsRevocationInfo() == null) continue;
                    return xmlTrustedService.getExpiredCertsRevocationInfo();
                }
            }
        }
        return null;
    }

    public String getSerialNumber() {
        BigInteger serialNumber = this.certificate.getSerialNumber();
        return serialNumber == null ? "" : serialNumber.toString();
    }

    public String getSubjectSerialNumber() {
        return this.certificate.getSubjectSerialNumber();
    }

    public String getTitle() {
        return this.certificate.getTitle();
    }

    public String getCommonName() {
        return this.certificate.getCommonName();
    }

    public String getCountryName() {
        return this.certificate.getCountryName();
    }

    public String getGivenName() {
        return this.certificate.getGivenName();
    }

    public String getOrganizationIdentifier() {
        return this.certificate.getOrganizationIdentifier();
    }

    public String getOrganizationName() {
        return this.certificate.getOrganizationName();
    }

    public String getOrganizationalUnit() {
        return this.certificate.getOrganizationalUnit();
    }

    public String getEmail() {
        return this.certificate.getEmail();
    }

    public String getLocality() {
        return this.certificate.getLocality();
    }

    public String getState() {
        return this.certificate.getState();
    }

    public String getSurname() {
        return this.certificate.getSurname();
    }

    public String getPseudo() {
        return this.certificate.getPseudonym();
    }

    public XmlDigestAlgoAndValue getDigestAlgoAndValue() {
        return this.certificate.getDigestAlgoAndValue();
    }

    public boolean isTrustedListReached() {
        List<XmlTrustedServiceProvider> tsps = this.certificate.getTrustedServiceProviders();
        return tsps != null && !tsps.isEmpty();
    }

    public List<XmlTrustedServiceProvider> getTrustServiceProviders() {
        return this.certificate.getTrustedServiceProviders();
    }

    public List<TrustedServiceWrapper> getTrustedServices() {
        ArrayList<TrustedServiceWrapper> result = new ArrayList<TrustedServiceWrapper>();
        List<XmlTrustedServiceProvider> tsps = this.certificate.getTrustedServiceProviders();
        if (tsps != null) {
            for (XmlTrustedServiceProvider tsp : tsps) {
                List<String> tspNames = this.getValues(tsp.getTSPNames());
                List<String> tspTradeNames = this.getValues(tsp.getTSPTradeNames());
                List<XmlTrustedService> trustedServices = tsp.getTrustedServices();
                if (trustedServices == null) continue;
                for (XmlTrustedService trustedService : trustedServices) {
                    TrustedServiceWrapper wrapper = new TrustedServiceWrapper();
                    wrapper.setTrustedList(tsp.getTL());
                    wrapper.setListOfTrustedLists(tsp.getLOTL());
                    wrapper.setTspNames(tspNames);
                    wrapper.setTspTradeNames(tspTradeNames);
                    wrapper.setServiceDigitalIdentifier(new CertificateWrapper(trustedService.getServiceDigitalIdentifier()));
                    wrapper.setServiceNames(this.getValues(trustedService.getServiceNames()));
                    wrapper.setStatus(trustedService.getStatus());
                    wrapper.setType(trustedService.getServiceType());
                    wrapper.setStartDate(trustedService.getStartDate());
                    wrapper.setEndDate(trustedService.getEndDate());
                    wrapper.setCapturedQualifiers(new ArrayList<String>(trustedService.getCapturedQualifiers()));
                    wrapper.setAdditionalServiceInfos(new ArrayList<String>(trustedService.getAdditionalServiceInfoUris()));
                    wrapper.setEnactedMRA(trustedService.isEnactedMRA());
                    XmlMRATrustServiceMapping mraTrustServiceMapping = trustedService.getMRATrustServiceMapping();
                    if (mraTrustServiceMapping != null) {
                        wrapper.setMraTrustServiceLegalIdentifier(mraTrustServiceMapping.getTrustServiceLegalIdentifier());
                        wrapper.setMraTrustServiceEquivalenceStatusStartingTime(mraTrustServiceMapping.getEquivalenceStatusStartingTime());
                        wrapper.setMraTrustServiceEquivalenceStatusEndingTime(mraTrustServiceMapping.getEquivalenceStatusEndingTime());
                        XmlOriginalThirdCountryTrustedServiceMapping originalThirdCountryMapping = mraTrustServiceMapping.getOriginalThirdCountryMapping();
                        if (originalThirdCountryMapping != null) {
                            wrapper.setOriginalTCType(originalThirdCountryMapping.getServiceType());
                            wrapper.setOriginalTCStatus(originalThirdCountryMapping.getStatus());
                            wrapper.setOriginalCapturedQualifiers(originalThirdCountryMapping.getCapturedQualifiers());
                            wrapper.setOriginalTCAdditionalServiceInfos(originalThirdCountryMapping.getAdditionalServiceInfoUris());
                        }
                    }
                    result.add(wrapper);
                }
            }
        }
        return result;
    }

    private List<String> getValues(List<XmlLangAndValue> langAndValues) {
        return langAndValues.stream().map(XmlLangAndValue::getValue).collect(Collectors.toList());
    }

    public String getCertificateDN() {
        DistinguishedNameListWrapper distinguishedNameListWrapper = new DistinguishedNameListWrapper(this.certificate.getSubjectDistinguishedName());
        return distinguishedNameListWrapper.getValue("RFC2253");
    }

    public String getCertificateIssuerDN() {
        DistinguishedNameListWrapper distinguishedNameListWrapper = new DistinguishedNameListWrapper(this.certificate.getIssuerDistinguishedName());
        return distinguishedNameListWrapper.getValue("RFC2253");
    }

    public List<String> getCRLDistributionPoints() {
        XmlCRLDistributionPoints crlDistributionPoints = this.getXmlCRLDistributionPoints();
        if (crlDistributionPoints != null) {
            return crlDistributionPoints.getCrlUrl();
        }
        return Collections.emptyList();
    }

    private XmlCRLDistributionPoints getXmlCRLDistributionPoints() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.CRL_DISTRIBUTION_POINTS.getOid(), XmlCRLDistributionPoints.class);
    }

    @Deprecated
    public List<String> getAuthorityInformationAccessUrls() {
        return this.getCAIssuersAccessUrls();
    }

    public List<String> getCAIssuersAccessUrls() {
        XmlAuthorityInformationAccess authorityInformationAccess = this.getXmlAuthorityInformationAccess();
        if (authorityInformationAccess != null) {
            return authorityInformationAccess.getCaIssuersUrls();
        }
        return Collections.emptyList();
    }

    public List<String> getOCSPAccessUrls() {
        XmlAuthorityInformationAccess authorityInformationAccess = this.getXmlAuthorityInformationAccess();
        if (authorityInformationAccess != null) {
            return authorityInformationAccess.getOcspUrls();
        }
        return Collections.emptyList();
    }

    private XmlAuthorityInformationAccess getXmlAuthorityInformationAccess() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.AUTHORITY_INFORMATION_ACCESS.getOid(), XmlAuthorityInformationAccess.class);
    }

    public byte[] getSubjectKeyIdentifier() {
        XmlSubjectKeyIdentifier xmlSubjectKeyIdentifier = this.getXmlSubjectKeyIdentifier();
        if (xmlSubjectKeyIdentifier != null) {
            return xmlSubjectKeyIdentifier.getSki();
        }
        return null;
    }

    private XmlSubjectKeyIdentifier getXmlSubjectKeyIdentifier() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.SUBJECT_KEY_IDENTIFIER.getOid(), XmlSubjectKeyIdentifier.class);
    }

    public List<String> getCpsUrls() {
        ArrayList<String> result = new ArrayList<String>();
        XmlCertificatePolicies xmlCertificatePolicies = this.getXmlCertificatePolicies();
        if (xmlCertificatePolicies != null) {
            for (XmlCertificatePolicy xmlCertificatePolicy : xmlCertificatePolicies.getCertificatePolicy()) {
                String cpsUrl = xmlCertificatePolicy.getCpsUrl();
                if (cpsUrl == null) continue;
                result.add(cpsUrl);
            }
        }
        return result;
    }

    public List<String> getPolicyIds() {
        XmlCertificatePolicies xmlCertificatePolicies = this.getXmlCertificatePolicies();
        if (xmlCertificatePolicies != null) {
            List<XmlCertificatePolicy> certificatePolicyIds = xmlCertificatePolicies.getCertificatePolicy();
            return this.getOidValues(certificatePolicyIds);
        }
        return Collections.emptyList();
    }

    public List<XmlCertificatePolicy> getCertificatePolicies() {
        XmlCertificatePolicies xmlCertificatePolicies = this.getXmlCertificatePolicies();
        if (xmlCertificatePolicies != null) {
            return xmlCertificatePolicies.getCertificatePolicy();
        }
        return Collections.emptyList();
    }

    private XmlCertificatePolicies getXmlCertificatePolicies() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.CERTIFICATE_POLICIES.getOid(), XmlCertificatePolicies.class);
    }

    public boolean isQcCompliance() {
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        return xmlQcStatements != null && xmlQcStatements.getQcCompliance() != null && xmlQcStatements.getQcCompliance().isPresent();
    }

    public boolean isSupportedByQSCD() {
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        return xmlQcStatements != null && xmlQcStatements.getQcSSCD() != null && xmlQcStatements.getQcSSCD().isPresent();
    }

    public List<QCType> getQcTypes() {
        ArrayList<QCType> result = new ArrayList<QCType>();
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        if (xmlQcStatements != null && xmlQcStatements.getQcTypes() != null) {
            for (XmlOID oid : xmlQcStatements.getQcTypes()) {
                result.add(QCType.fromOid(oid.getValue()));
            }
        }
        return result;
    }

    public List<String> getQcLegislationCountryCodes() {
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        if (xmlQcStatements != null && xmlQcStatements.getQcCClegislation() != null) {
            return xmlQcStatements.getQcCClegislation();
        }
        return Collections.emptyList();
    }

    public PSD2InfoWrapper getPSD2Info() {
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        if (xmlQcStatements != null && xmlQcStatements.getPSD2QcInfo() != null) {
            return new PSD2InfoWrapper(xmlQcStatements.getPSD2QcInfo());
        }
        return null;
    }

    public QCLimitValueWrapper getQCLimitValue() {
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        if (xmlQcStatements != null && xmlQcStatements.getQcEuLimitValue() != null) {
            return new QCLimitValueWrapper(xmlQcStatements.getQcEuLimitValue());
        }
        return null;
    }

    public Integer getQCEuRetentionPeriod() {
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        if (xmlQcStatements != null) {
            return xmlQcStatements.getQcEuRetentionPeriod();
        }
        return null;
    }

    public List<XmlLangAndValue> getQCPDSLocations() {
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        if (xmlQcStatements != null) {
            return xmlQcStatements.getQcEuPDS();
        }
        return Collections.emptyList();
    }

    public SemanticsIdentifier getSemanticsIdentifier() {
        XmlOID xmlOID;
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        if (xmlQcStatements != null && xmlQcStatements.getSemanticsIdentifier() != null && (xmlOID = xmlQcStatements.getSemanticsIdentifier()) != null) {
            return SemanticsIdentifier.fromOid(xmlOID.getValue());
        }
        return null;
    }

    public List<String> getOtherQcStatements() {
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        if (xmlQcStatements != null && xmlQcStatements.getOtherOIDs() != null) {
            return this.getOidValues(xmlQcStatements.getOtherOIDs());
        }
        return Collections.emptyList();
    }

    public boolean isEnactedMRA() {
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        if (xmlQcStatements != null) {
            return xmlQcStatements.isEnactedMRA() != null && xmlQcStatements.isEnactedMRA() != false;
        }
        return false;
    }

    public String getMRAEnactedTrustServiceLegalIdentifier() {
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        if (xmlQcStatements != null && xmlQcStatements.getMRACertificateMapping() != null && xmlQcStatements.getMRACertificateMapping().getTrustServiceEquivalenceInformation() != null) {
            return xmlQcStatements.getMRACertificateMapping().getTrustServiceEquivalenceInformation().getTrustServiceLegalIdentifier();
        }
        return null;
    }

    public List<XmlCertificateContentEquivalence> getMRACertificateContentEquivalenceList() {
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        if (xmlQcStatements != null && xmlQcStatements.getMRACertificateMapping() != null && xmlQcStatements.getMRACertificateMapping().getTrustServiceEquivalenceInformation() != null) {
            return xmlQcStatements.getMRACertificateMapping().getTrustServiceEquivalenceInformation().getCertificateContentEquivalenceList();
        }
        return Collections.emptyList();
    }

    private XmlOriginalThirdCountryQcStatementsMapping getOriginalThirdCountryMapping() {
        XmlQcStatements xmlQcStatements = this.getXmlQcStatements();
        if (xmlQcStatements != null && xmlQcStatements.getMRACertificateMapping() != null) {
            return xmlQcStatements.getMRACertificateMapping().getOriginalThirdCountryMapping();
        }
        return null;
    }

    private XmlQcStatements getXmlQcStatements() {
        return this.getCertificateExtensionForOid(CertificateExtensionEnum.QC_STATEMENTS.getOid(), XmlQcStatements.class);
    }

    private List<String> getOidValues(List<? extends XmlOID> xmlOids) {
        ArrayList<String> result = new ArrayList<String>();
        if (xmlOids != null) {
            for (XmlOID xmlOID : xmlOids) {
                result.add(xmlOID.getValue());
            }
        }
        return result;
    }

    public boolean isOriginalThirdCountryQcCompliance() {
        XmlOriginalThirdCountryQcStatementsMapping originalThirdCountryMapping = this.getOriginalThirdCountryMapping();
        return originalThirdCountryMapping != null && originalThirdCountryMapping.getQcCompliance() != null && originalThirdCountryMapping.getQcCompliance().isPresent();
    }

    public boolean isOriginalThirdCountrySupportedByQSCD() {
        XmlOriginalThirdCountryQcStatementsMapping originalThirdCountryMapping = this.getOriginalThirdCountryMapping();
        return originalThirdCountryMapping != null && originalThirdCountryMapping.getQcSSCD() != null && originalThirdCountryMapping.getQcSSCD().isPresent();
    }

    public List<QCType> getOriginalThirdCountryQCTypes() {
        ArrayList<QCType> result = new ArrayList<QCType>();
        XmlOriginalThirdCountryQcStatementsMapping originalThirdCountryMapping = this.getOriginalThirdCountryMapping();
        if (originalThirdCountryMapping != null && originalThirdCountryMapping.getQcTypes() != null) {
            for (XmlOID oid : originalThirdCountryMapping.getQcTypes()) {
                result.add(QCType.fromOid(oid.getValue()));
            }
        }
        return result;
    }

    public List<String> getOriginalThirdCountryQcLegislationCountryCodes() {
        XmlOriginalThirdCountryQcStatementsMapping originalThirdCountryMapping = this.getOriginalThirdCountryMapping();
        if (originalThirdCountryMapping != null && originalThirdCountryMapping.getQcCClegislation() != null) {
            return originalThirdCountryMapping.getQcCClegislation();
        }
        return Collections.emptyList();
    }

    public List<String> getOriginalThirdCountryOtherQcStatements() {
        XmlOriginalThirdCountryQcStatementsMapping originalThirdCountryMapping = this.getOriginalThirdCountryMapping();
        if (originalThirdCountryMapping != null && originalThirdCountryMapping.getOtherOIDs() != null) {
            return this.getOidValues(originalThirdCountryMapping.getOtherOIDs());
        }
        return Collections.emptyList();
    }

    @Override
    public byte[] getBinaries() {
        return this.certificate.getBase64Encoded();
    }

    public String getReadableCertificateName() {
        if (this.certificate.getCommonName() != null) {
            return this.certificate.getCommonName();
        }
        if (this.certificate.getGivenName() != null) {
            return this.certificate.getGivenName();
        }
        if (this.certificate.getSurname() != null) {
            return this.certificate.getSurname();
        }
        if (this.certificate.getPseudonym() != null) {
            return this.certificate.getPseudonym();
        }
        if (this.certificate.getOrganizationName() != null) {
            return this.certificate.getOrganizationName();
        }
        if (this.certificate.getOrganizationalUnit() != null) {
            return this.certificate.getOrganizationalUnit();
        }
        return "?";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateWrapper)) {
            return false;
        }
        AbstractTokenProxy other = (AbstractTokenProxy)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }
}

