/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateRef;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;

public class CertificateRefWrapper {
    private final XmlCertificateRef certificateRef;
    private final String certificateId;

    public CertificateRefWrapper(XmlCertificateRef certificateRef, String certificateId) {
        this.certificateRef = certificateRef;
        this.certificateId = certificateId;
    }

    public CertificateRefOrigin getOrigin() {
        return this.certificateRef.getOrigin();
    }

    public byte[] getIssuerSerial() {
        if (this.certificateRef.getIssuerSerial() != null) {
            return this.certificateRef.getIssuerSerial().getValue();
        }
        return null;
    }

    public boolean isIssuerSerialPresent() {
        return this.certificateRef.getIssuerSerial() != null;
    }

    public boolean isIssuerSerialMatch() {
        if (this.certificateRef.getIssuerSerial() != null && this.certificateRef.getIssuerSerial().isMatch() != null) {
            return this.certificateRef.getIssuerSerial().isMatch();
        }
        return false;
    }

    public String getIssuerName() {
        if (this.certificateRef.getSerialInfo() != null) {
            return this.certificateRef.getSerialInfo().getIssuerName();
        }
        return null;
    }

    public byte[] getSki() {
        if (this.certificateRef.getSerialInfo() != null) {
            return this.certificateRef.getSerialInfo().getSki();
        }
        return null;
    }

    public XmlDigestAlgoAndValue getDigestAlgoAndValue() {
        return this.certificateRef.getDigestAlgoAndValue();
    }

    public boolean isDigestValuePresent() {
        return this.getDigestAlgoAndValue() != null;
    }

    public DigestAlgorithm getDigestMethod() {
        XmlDigestAlgoAndValue digestAlgoAndValue = this.getDigestAlgoAndValue();
        if (digestAlgoAndValue != null) {
            return digestAlgoAndValue.getDigestMethod();
        }
        return null;
    }

    public boolean isDigestValueMatch() {
        XmlDigestAlgoAndValue digestAlgoAndValue = this.getDigestAlgoAndValue();
        return digestAlgoAndValue != null && digestAlgoAndValue.isMatch() != null && digestAlgoAndValue.isMatch() != false;
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public String toString() {
        if (this.certificateRef != null) {
            return "CertificateRefWrapper Origin='" + (Object)((Object)this.certificateRef.getOrigin()) + "'";
        }
        return "CertificateRefWrapper certificateRef=" + this.certificateRef;
    }
}

