/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.crl.PemToDerConverter;
import eu.europa.esig.dss.model.DSSException;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCRLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCRLUtils.class);

    protected AbstractCRLUtils() {
    }

    public CRLBinary buildCRLBinary(byte[] binaries) {
        return new CRLBinary(this.getDERContent(binaries));
    }

    private byte[] getDERContent(byte[] binaries) {
        if (binaries != null && binaries.length > 0) {
            byte first = binaries[0];
            if (this.isDerEncoded(first)) {
                return binaries;
            }
            if (this.isPemEncoded(first)) {
                return PemToDerConverter.convert(binaries);
            }
            throw new DSSException("Unable to load CRL. Not possible to convert to DER!");
        }
        throw new DSSException("Unsupported CRL. The obtained CRL content is empty!");
    }

    private boolean isDerEncoded(byte first) {
        return 48 == first;
    }

    private boolean isPemEncoded(byte first) {
        return 45 == first;
    }

    protected void extractExpiredCertsOnCRL(CRLValidity validity, byte[] expiredCertsOnCRLBinaries) {
        if (expiredCertsOnCRLBinaries != null) {
            try {
                ASN1OctetString octetString = (ASN1OctetString)ASN1Primitive.fromByteArray(expiredCertsOnCRLBinaries);
                Time time = Time.getInstance(ASN1Primitive.fromByteArray(octetString.getOctets()));
                if (time != null && time.toASN1Primitive() instanceof ASN1GeneralizedTime) {
                    validity.setExpiredCertsOnCRL(time.getDate());
                } else {
                    LOG.warn("Attribute 'expiredCertsOnCRL' found but ignored (should be encoded as ASN.1 GeneralizedTime)");
                }
            }
            catch (Exception e) {
                LOG.error("Unable to parse expiredCertsOnCRL on CRL : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected void extractIssuingDistributionPointBinary(CRLValidity validity, byte[] issuingDistributionPointBinary) {
        if (issuingDistributionPointBinary != null) {
            IssuingDistributionPoint issuingDistributionPoint = IssuingDistributionPoint.getInstance(ASN1OctetString.getInstance(issuingDistributionPointBinary).getOctets());
            validity.setOnlyAttributeCerts(issuingDistributionPoint.onlyContainsAttributeCerts());
            validity.setOnlyCaCerts(issuingDistributionPoint.onlyContainsCACerts());
            validity.setOnlyUserCerts(issuingDistributionPoint.onlyContainsUserCerts());
            validity.setIndirectCrl(issuingDistributionPoint.isIndirectCRL());
            validity.setReasonFlags(issuingDistributionPoint.getOnlySomeReasons());
            validity.setUrl(this.getUrl(issuingDistributionPoint.getDistributionPoint()));
        } else {
            LOG.debug("issuingDistributionPointBinary is null. Issuing Distribution Point fields in CRLValidity cannot be filled.");
        }
    }

    private String getUrl(DistributionPointName distributionPoint) {
        GeneralNames generalNames;
        if (distributionPoint != null && 0 == distributionPoint.getType() && (generalNames = (GeneralNames)distributionPoint.getName()) != null && generalNames.getNames() != null && generalNames.getNames().length > 0) {
            for (GeneralName generalName : generalNames.getNames()) {
                if (6 != generalName.getTagNo()) continue;
                ASN1String str = (ASN1String)((Object)((DERTaggedObject)generalName.toASN1Primitive()).getBaseObject());
                return str.getString();
            }
        }
        return null;
    }
}

