/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.DefaultSignaturePolicyValidatorLoader;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESSignaturePolicyStoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignaturePolicyStoreBuilder.class);

    public DSSDocument addSignaturePolicyStore(DSSDocument signatureDocument, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(signatureDocument, "Signature document must be provided!");
        CMSSignedData originalCmsSignedData = DSSUtils.toCMSSignedData(signatureDocument);
        CMSSignedData newCmsSignedData = this.extendCMSSignedData(originalCmsSignedData, signaturePolicyStore);
        newCmsSignedData = CMSUtils.populateDigestAlgorithmSet(newCmsSignedData, originalCmsSignedData);
        return new CMSSignedDocument(newCmsSignedData);
    }

    public CMSSignedData extendCMSSignedData(CMSSignedData cmsSignedData, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(cmsSignedData, "CMSSignedData must be provided!");
        this.assertConfigurationValid(signaturePolicyStore);
        CMSDocumentValidator documentValidator = new CMSDocumentValidator(cmsSignedData);
        List<AdvancedSignature> signatures = documentValidator.getSignatures();
        if (Utils.isCollectionEmpty(signatures)) {
            throw new IllegalInputException("Unable to extend the document! No signatures found.");
        }
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        boolean signaturePolicyStoreAdded = false;
        for (AdvancedSignature signature : signatures) {
            CAdESSignature cadesSignature = (CAdESSignature)signature;
            SignerInformation newSignerInformation = this.addSignaturePolicyStoreIfDigestMatch(cadesSignature, signaturePolicyStore);
            if (cadesSignature.getSignerInformation() != newSignerInformation) {
                signaturePolicyStoreAdded = true;
            }
            newSignerInformationList.add(newSignerInformation);
        }
        if (!signaturePolicyStoreAdded) {
            throw new IllegalInputException("The process did not find a signature to add SignaturePolicyStore!");
        }
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        return CMSSignedData.replaceSigners(cmsSignedData, newSignerStore);
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument signatureDocument, SignaturePolicyStore signaturePolicyStore, String signatureId) {
        Objects.requireNonNull(signatureDocument, "Signature document must be provided!");
        CMSSignedData originalCmsSignedData = DSSUtils.toCMSSignedData(signatureDocument);
        CMSSignedData newCmsSignedData = this.extendCMSSignedData(originalCmsSignedData, signaturePolicyStore, signatureId);
        newCmsSignedData = CMSUtils.populateDigestAlgorithmSet(newCmsSignedData, originalCmsSignedData);
        return new CMSSignedDocument(newCmsSignedData);
    }

    public CMSSignedData extendCMSSignedData(CMSSignedData cmsSignedData, SignaturePolicyStore signaturePolicyStore, String signatureId) {
        Objects.requireNonNull(cmsSignedData, "CMSSignedData must be provided!");
        this.assertConfigurationValid(signaturePolicyStore);
        CMSDocumentValidator documentValidator = new CMSDocumentValidator(cmsSignedData);
        AdvancedSignature signature = documentValidator.getSignatureById(signatureId);
        if (signature == null) {
            throw new IllegalInputException(String.format("Unable to find a signature with Id : %s!", signatureId));
        }
        ArrayList<SignerInformation> newSignerInformationList = new ArrayList<SignerInformation>();
        for (AdvancedSignature currentSignature : documentValidator.getSignatures()) {
            CAdESSignature cadesSignature = (CAdESSignature)currentSignature;
            if (signature.equals(cadesSignature)) {
                SignerInformation newSignerInformation = this.addSignaturePolicyStoreIfDigestMatch(cadesSignature, signaturePolicyStore);
                if (cadesSignature.getSignerInformation() == newSignerInformation) {
                    throw new IllegalInputException(String.format("The process was not able to add SignaturePolicyStore to a signature with Id : %s!", signatureId));
                }
                newSignerInformationList.add(newSignerInformation);
                continue;
            }
            newSignerInformationList.add(cadesSignature.getSignerInformation());
        }
        SignerInformationStore newSignerStore = new SignerInformationStore(newSignerInformationList);
        return CMSSignedData.replaceSigners(cmsSignedData, newSignerStore);
    }

    protected SignerInformation addSignaturePolicyStoreIfDigestMatch(CAdESSignature cadesSignature, SignaturePolicyStore signaturePolicyStore) {
        SignerInformation signerInformation = cadesSignature.getSignerInformation();
        this.assertSignaturePolicyStoreExtensionPossible(signerInformation);
        SignerInformation newSignerInformation = signerInformation;
        if (this.checkDigest(cadesSignature, signaturePolicyStore)) {
            newSignerInformation = this.addSignaturePolicyStore(signerInformation, signaturePolicyStore);
        }
        return newSignerInformation;
    }

    protected boolean checkDigest(CAdESSignature cadesSignature, SignaturePolicyStore signaturePolicyStore) {
        SignaturePolicy signaturePolicy = cadesSignature.getSignaturePolicy();
        if (signaturePolicy == null) {
            LOG.warn("signature-policy-identifier is not defined for a signature with Id : {}", (Object)cadesSignature.getId());
            return false;
        }
        Digest expectedDigest = signaturePolicy.getDigest();
        if (expectedDigest == null) {
            LOG.warn("signature-policy-identifier digest is not found for a signature with Id : {}", (Object)cadesSignature.getId());
            return false;
        }
        DSSDocument signaturePolicyContent = signaturePolicyStore.getSignaturePolicyContent();
        if (signaturePolicyContent == null) {
            LOG.info("No policy document has been provided. Digests are not checked!");
            return true;
        }
        signaturePolicy.setPolicyContent(signaturePolicyContent);
        SignaturePolicyValidator validator = new DefaultSignaturePolicyValidatorLoader().loadValidator(signaturePolicy);
        Digest computedDigest = validator.getComputedDigest(signaturePolicyContent, expectedDigest.getAlgorithm());
        boolean digestMatch = expectedDigest.equals(computedDigest);
        if (!digestMatch) {
            LOG.warn("Signature policy's digest {} doesn't match the digest extracted from document {} for signature with Id : {}", computedDigest, expectedDigest, cadesSignature.getId());
        }
        return digestMatch;
    }

    private SignerInformation addSignaturePolicyStore(SignerInformation signerInformation, SignaturePolicyStore signaturePolicyStore) {
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        ASN1Sequence sigPolicyStore = this.getSignaturePolicyStore(signaturePolicyStore);
        AttributeTable unsignedAttributesWithPolicyStore = unsignedAttributes.add(OID.id_aa_ets_sigPolicyStore, sigPolicyStore);
        return SignerInformation.replaceUnsignedAttributes(signerInformation, unsignedAttributesWithPolicyStore);
    }

    private ASN1Sequence getSignaturePolicyStore(SignaturePolicyStore signaturePolicyStore) {
        String sigPolDocLocalURI;
        ASN1EncodableVector sigPolicyStore = new ASN1EncodableVector();
        sigPolicyStore.add(DSSASN1Utils.buildSPDocSpecificationId(signaturePolicyStore.getSpDocSpecification().getId()));
        DSSDocument signaturePolicyContent = signaturePolicyStore.getSignaturePolicyContent();
        if (signaturePolicyContent != null) {
            sigPolicyStore.add(new DEROctetString(DSSUtils.toByteArray(signaturePolicyStore.getSignaturePolicyContent())));
        }
        if ((sigPolDocLocalURI = signaturePolicyStore.getSigPolDocLocalURI()) != null) {
            sigPolicyStore.add(new DERIA5String(sigPolDocLocalURI));
        }
        return new DERSequence(sigPolicyStore);
    }

    private void assertConfigurationValid(SignaturePolicyStore signaturePolicyStore) {
        boolean sigPolDocLocalURIPresent;
        Objects.requireNonNull(signaturePolicyStore, "SignaturePolicyStore must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification(), "SpDocSpecification must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification().getId(), "ID (OID or URI) for SpDocSpecification must be provided");
        boolean signaturePolicyContentPresent = signaturePolicyStore.getSignaturePolicyContent() != null;
        boolean bl = sigPolDocLocalURIPresent = signaturePolicyStore.getSigPolDocLocalURI() != null;
        if (!(signaturePolicyContentPresent ^ sigPolDocLocalURIPresent)) {
            throw new IllegalArgumentException("SignaturePolicyStore shall contain either SignaturePolicyContent document or sigPolDocLocalURI!");
        }
    }

    private void assertSignaturePolicyStoreExtensionPossible(SignerInformation signerInformation) {
        if (CMSUtils.containsATSTv2(signerInformation)) {
            throw new IllegalInputException("Cannot add signature policy store to a CAdES containing an archiveTimestampV2");
        }
    }
}

