/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades;

import eu.europa.esig.dss.cades.signature.CustomMessageDigestCalculatorProvider;
import eu.europa.esig.dss.cades.validation.PrecomputedDigestCalculatorProvider;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSProcessableFile;
import org.bouncycastle.cms.CMSReadable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CMSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CMSUtils.class);
    public static final DigestAlgorithm DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO = DigestAlgorithm.SHA256;
    private static final Date JANUARY_1950 = DSSUtils.getUtcDate(1950, 0, 1);
    private static final Date JANUARY_2050 = DSSUtils.getUtcDate(2050, 0, 1);

    private CMSUtils() {
    }

    public static CMSSignedData generateCMSSignedData(CMSSignedDataGenerator generator, CMSTypedData content, boolean encapsulate) {
        try {
            return generator.generate(content, encapsulate);
        }
        catch (CMSException e) {
            throw new DSSException("Unable to generate the CMSSignedData", e);
        }
    }

    public static SignerInformationStore generateCounterSigners(CMSSignedDataGenerator cmsSignedDataGenerator, SignerInformation signerInfoToSign) {
        try {
            return cmsSignedDataGenerator.generateCounterSigners(signerInfoToSign);
        }
        catch (CMSException e) {
            throw new DSSException("Unable to generate the SignerInformationStore for the counter-signature", e);
        }
    }

    public static CMSSignedData generateDetachedCMSSignedData(CMSSignedDataGenerator generator, CMSProcessableByteArray content) {
        return CMSUtils.generateCMSSignedData(generator, content, false);
    }

    public static CMSSignedData populateDigestAlgorithmSet(CMSSignedData newCmsSignedData, CMSSignedData oldCmsSignedData) {
        if (oldCmsSignedData != null) {
            for (AlgorithmIdentifier algorithmIdentifier : oldCmsSignedData.getDigestAlgorithmIDs()) {
                newCmsSignedData = CMSUtils.addDigestAlgorithm(newCmsSignedData, algorithmIdentifier);
            }
        }
        return newCmsSignedData;
    }

    public static CMSSignedData addDigestAlgorithm(CMSSignedData cmsSignedData, AlgorithmIdentifier algorithmIdentifier) {
        return CMSSignedData.addDigestAlgorithm(cmsSignedData, algorithmIdentifier);
    }

    public static DERTaggedObject getDERSignedAttributes(SignerInformation signerInformation) {
        try {
            byte[] encodedSignedAttributes = signerInformation.getEncodedSignedAttributes();
            if (encodedSignedAttributes == null) {
                return null;
            }
            ASN1Set asn1Set = (ASN1Set)DSSASN1Utils.toASN1Primitive(encodedSignedAttributes);
            return new DERTaggedObject(false, 0, (ASN1Encodable)asn1Set);
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to extract SignedAttributes. Reason : %s", e.getMessage()), e);
        }
    }

    public static byte[] getSignedContent(CMSTypedData cmsTypedData) {
        byte[] byArray;
        if (cmsTypedData == null) {
            throw new DSSException("CMSTypedData is null (should be a detached signature)");
        }
        ByteArrayOutputStream originalDocumentData = new ByteArrayOutputStream();
        try {
            cmsTypedData.write(originalDocumentData);
            byArray = originalDocumentData.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    originalDocumentData.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CMSException e) {
                throw new DSSException(e);
            }
        }
        originalDocumentData.close();
        return byArray;
    }

    public static AttributeTable getUnsignedAttributes(SignerInformation signerInformation) {
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        return DSSASN1Utils.emptyIfNull(unsignedAttributes);
    }

    public static AttributeTable getSignedAttributes(SignerInformation signerInformation) {
        AttributeTable signedAttributes = signerInformation.getSignedAttributes();
        return DSSASN1Utils.emptyIfNull(signedAttributes);
    }

    public static AttributeTable getAttributesFromByteArray(byte[] encodedAttributes) {
        DLSet dlSet;
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(new ByteArrayInputStream(encodedAttributes));){
            dlSet = (DLSet)asn1InputStream.readObject();
        }
        catch (IOException e) {
            throw new DSSException("Error while reading ASN.1 encoded attributes", e);
        }
        return new AttributeTable(dlSet);
    }

    public static void addSigningCertificateAttribute(ASN1EncodableVector signedAttributes, DigestAlgorithm digestAlgorithm, CertificateToken signingToken) {
        Attribute attribute;
        IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial(signingToken);
        byte[] certHash = signingToken.getDigest(digestAlgorithm);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding Certificate Hash {} with algorithm {}", (Object)Utils.toHex(certHash), (Object)digestAlgorithm.getName());
        }
        if (digestAlgorithm == DigestAlgorithm.SHA1) {
            ESSCertID essCertID = new ESSCertID(certHash, issuerSerial);
            SigningCertificate signingCertificate = new SigningCertificate(essCertID);
            attribute = new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificate, new DERSet(signingCertificate));
        } else {
            ESSCertIDv2 essCertIdv2 = DigestAlgorithm.SHA256 == digestAlgorithm ? new ESSCertIDv2(null, certHash, issuerSerial) : new ESSCertIDv2(DSSASN1Utils.getAlgorithmIdentifier(digestAlgorithm), certHash, issuerSerial);
            SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(essCertIdv2);
            attribute = new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, new DERSet(signingCertificateV2));
        }
        signedAttributes.add(attribute);
    }

    public static boolean isCMSSignedDataEqual(CMSSignedData signedData, CMSSignedData signedDataToCompare) throws IOException {
        return Arrays.equals(signedData.getEncoded(), signedDataToCompare.getEncoded());
    }

    public static Attribute getSignedAttribute(SignerInformation signerInformation, ASN1ObjectIdentifier oid) {
        AttributeTable signedAttributes = signerInformation.getSignedAttributes();
        if (signedAttributes == null) {
            return null;
        }
        return signedAttributes.get(oid);
    }

    public static Attribute getUnsignedAttribute(SignerInformation signerInformation, ASN1ObjectIdentifier oid) {
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            return null;
        }
        return unsignedAttributes.get(oid);
    }

    public static boolean isDetachedSignature(CMSSignedData cmsSignedData) {
        return cmsSignedData.isDetachedSignature();
    }

    public static DSSDocument getOriginalDocument(CMSSignedData cmsSignedData, List<DSSDocument> detachedDocuments) {
        CMSTypedData signedContent = null;
        if (cmsSignedData != null) {
            signedContent = cmsSignedData.getSignedContent();
        }
        if (signedContent != null && !CMSUtils.isDetachedSignature(cmsSignedData)) {
            return new InMemoryDocument(CMSUtils.getSignedContent(signedContent));
        }
        if (Utils.collectionSize(detachedDocuments) == 1) {
            return detachedDocuments.get(0);
        }
        throw new DSSException("Only enveloping and detached signatures are supported");
    }

    public static CMSTypedData getContentToBeSigned(DSSDocument toSignData) {
        CMSReadable content;
        Objects.requireNonNull(toSignData, "Document to be signed is missing");
        if (toSignData instanceof DigestDocument) {
            content = new CMSAbsentContent();
        } else if (toSignData instanceof FileDocument) {
            FileDocument fileDocument = (FileDocument)toSignData;
            content = new CMSProcessableFile(fileDocument.getFile());
        } else {
            content = new CMSProcessableByteArray(DSSUtils.toByteArray(toSignData));
        }
        return content;
    }

    public static DigestCalculatorProvider getDigestCalculatorProvider(DSSDocument toSignDocument, DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm != null) {
            return new CustomMessageDigestCalculatorProvider(digestAlgorithm, toSignDocument.getDigest(digestAlgorithm));
        }
        if (toSignDocument instanceof DigestDocument) {
            return new PrecomputedDigestCalculatorProvider((DigestDocument)toSignDocument);
        }
        return new BcDigestCalculatorProvider();
    }

    public static boolean containsATSTv2(SignerInformation signerInformation) {
        Attribute[] attributes;
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        for (Attribute attribute : attributes = unsignedAttributes.toASN1Structure().getAttributes()) {
            if (!DSSASN1Utils.isAttributeOfType(attribute, OID.id_aa_ets_archiveTimestampV2)) continue;
            return true;
        }
        return false;
    }

    public static Date readSigningDate(ASN1Encodable attrValue) {
        if (attrValue != null) {
            Date signingDate = DSSASN1Utils.getDate(attrValue);
            if (signingDate != null) {
                if (signingDate.compareTo(JANUARY_1950) >= 0 && signingDate.before(JANUARY_2050) && !(attrValue.toASN1Primitive() instanceof ASN1UTCTime)) {
                    LOG.warn("RFC 3852 states that dates between January 1, 1950 and December 31, 2049 (inclusive) MUST be encoded as UTCTime. Any dates with year values before 1950 or after 2049 MUST be encoded as GeneralizedTime. Date found is {} encoded as {}", (Object)signingDate, (Object)attrValue.getClass());
                    return null;
                }
                return signingDate;
            }
            LOG.warn("Error when reading signing time. Unrecognized {}", (Object)attrValue.getClass());
        }
        return null;
    }
}

