/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.merge;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.xades.merge.AbstractASiCWithXAdESContainerMerger;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XMLDocumentValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.xml.security.signature.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASiCSWithXAdESContainerMerger
extends AbstractASiCWithXAdESContainerMerger {
    ASiCSWithXAdESContainerMerger() {
    }

    public ASiCSWithXAdESContainerMerger(DSSDocument ... containers) {
        super(containers);
    }

    public ASiCSWithXAdESContainerMerger(ASiCContent ... asicContents) {
        super(asicContents);
    }

    @Override
    protected boolean isSupported(DSSDocument container) {
        return super.isSupported(container) && !ASiCUtils.isASiCEContainer(container);
    }

    @Override
    protected boolean isSupported(ASiCContent asicContent) {
        return super.isSupported(asicContent) && !ASiCUtils.isASiCEContainer(asicContent);
    }

    @Override
    protected ASiCContainerType getTargetASiCContainerType() {
        return ASiCContainerType.ASiC_S;
    }

    @Override
    protected void ensureContainerContentAllowMerge() {
        if (Arrays.stream(this.asicContents).allMatch(asicContent -> Utils.isCollectionEmpty(asicContent.getSignatureDocuments()))) {
            return;
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.collectionSize(asicContent.getSignatureDocuments()) > 1)) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. One of the containers has more than one signature documents!");
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> asicContent.getSignatureDocuments().stream().anyMatch(document -> !"META-INF/signatures.xml".equals(document.getName())))) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. The signature document in one of the containers has invalid naming!");
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.isCollectionNotEmpty(asicContent.getTimestampDocuments()))) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. One of the containers contains a detached timestamp!");
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.collectionSize(asicContent.getRootLevelSignedDocuments()) > 1)) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. One of the containers has more than one signer documents!");
        }
        if (Utils.collectionSize(this.getSignerDocumentNameSet()) > 1) {
            throw new UnsupportedOperationException("Unable to merge ASiC-S with XAdES containers. Signer documents have different names!");
        }
    }

    private Set<String> getSignerDocumentNameSet() {
        HashSet<String> result = new HashSet<String>();
        for (ASiCContent asicContent : this.asicContents) {
            result.addAll(DSSUtils.getDocumentNames(asicContent.getRootLevelSignedDocuments()));
        }
        return result;
    }

    @Override
    protected void ensureSignaturesAllowMerge() {
        if (Arrays.stream(this.asicContents).filter(asicContent -> Utils.isCollectionNotEmpty(asicContent.getSignatureDocuments())).count() <= 1L) {
            return;
        }
        List<XMLDocumentValidator> documentValidators = this.getAllDocumentValidators();
        List<AdvancedSignature> allSignatures = this.getAllSignatures(documentValidators);
        if (!this.checkNoCommonIdsBetweenSignatures(allSignatures)) {
            throw new IllegalInputException("Signature documents contain signatures with the same identifiers!");
        }
        if (!this.checkNoCommonIdsBetweenSignedData(allSignatures)) {
            throw new IllegalInputException("Signature documents contain signatures signed enveloped objects with the same identifiers!");
        }
        if (!this.checkNoCommonIdsBetweenSignatureValues(allSignatures)) {
            throw new IllegalInputException("Signature documents contain signatures with SignatureValue elements sharing the same ids!");
        }
        this.assertSameRootElement(documentValidators);
        DSSDocument signaturesXml = this.getMergedSignaturesXml(documentValidators);
        for (ASiCContent asicContent2 : this.asicContents) {
            asicContent2.setSignatureDocuments(Collections.singletonList(signaturesXml));
        }
    }

    private List<XMLDocumentValidator> getAllDocumentValidators() {
        ArrayList<XMLDocumentValidator> validators = new ArrayList<XMLDocumentValidator>();
        for (ASiCContent asicContent : this.asicContents) {
            for (DSSDocument signatureDocument : asicContent.getSignatureDocuments()) {
                validators.add(new XMLDocumentValidator(signatureDocument));
            }
        }
        return validators;
    }

    private List<AdvancedSignature> getAllSignatures(List<XMLDocumentValidator> validators) {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        for (XMLDocumentValidator validator : validators) {
            signatures.addAll(validator.getSignatures());
        }
        return signatures;
    }

    private boolean checkNoCommonIdsBetweenSignatures(List<AdvancedSignature> signatures) {
        List<String> signatureIds = this.getSignatureIds(signatures);
        return !this.checkDuplicatesPresent(signatureIds);
    }

    private List<String> getSignatureIds(List<AdvancedSignature> signatures) {
        return signatures.stream().map(AdvancedSignature::getDAIdentifier).collect(Collectors.toList());
    }

    private boolean checkNoCommonIdsBetweenSignedData(List<AdvancedSignature> signatures) {
        List<String> signedDataObjectIdsOne = this.getSignedDataObjectIds(signatures);
        return !this.checkDuplicatesPresent(signedDataObjectIdsOne);
    }

    private List<String> getSignedDataObjectIds(List<AdvancedSignature> signatures) {
        ArrayList<String> ids = new ArrayList<String>();
        for (AdvancedSignature signature : signatures) {
            XAdESSignature xadesSignature = (XAdESSignature)signature;
            List<Reference> references = xadesSignature.getReferences();
            for (Reference reference : references) {
                String referenceURI = DSSXMLUtils.getReferenceURI(reference);
                if (referenceURI == null) continue;
                if ("".equals(referenceURI)) {
                    throw new IllegalInputException("Unable to merge signatures, as one of them covers the whole signature file document!");
                }
                if (!DomUtils.startsFromHash(referenceURI) && !DomUtils.isXPointerQuery(referenceURI)) continue;
                ids.add(referenceURI);
            }
        }
        return ids;
    }

    private boolean checkNoCommonIdsBetweenSignatureValues(List<AdvancedSignature> signatures) {
        List<String> signatureValueIds = this.getSignatureValueIds(signatures);
        return !this.checkDuplicatesPresent(signatureValueIds);
    }

    private List<String> getSignatureValueIds(List<AdvancedSignature> signatures) {
        ArrayList<String> ids = new ArrayList<String>();
        for (AdvancedSignature signature : signatures) {
            XAdESSignature xadesSignature = (XAdESSignature)signature;
            ids.add(xadesSignature.getSignatureValueId());
        }
        return ids;
    }

    private boolean checkDuplicatesPresent(List<String> strings) {
        for (String str : strings) {
            if (Collections.frequency(strings, str) <= 1) continue;
            return true;
        }
        return false;
    }

    private void assertSameRootElement(List<XMLDocumentValidator> documentValidators) {
        Element rootElement = null;
        for (XMLDocumentValidator documentValidator : documentValidators) {
            Element currentRootElement = documentValidator.getRootElement().getDocumentElement();
            if (rootElement == null) {
                rootElement = currentRootElement;
                continue;
            }
            if (!rootElement.getLocalName().equals(currentRootElement.getLocalName())) {
                throw new IllegalInputException("Signature containers have different root elements!");
            }
            if (rootElement.getNamespaceURI() != null ^ currentRootElement.getNamespaceURI() != null) {
                throw new IllegalInputException("Signature containers have different namespaces!");
            }
            if (rootElement.getNamespaceURI() != null && !rootElement.getNamespaceURI().equals(currentRootElement.getNamespaceURI())) {
                throw new IllegalInputException("Signature containers have different namespaces!");
            }
            if (rootElement.getPrefix().equals(currentRootElement.getPrefix())) continue;
            throw new IllegalInputException("Signature containers have different namespace prefixes!");
        }
    }

    private DSSDocument getMergedSignaturesXml(List<XMLDocumentValidator> documentValidators) {
        Document document = null;
        Element documentElement = null;
        for (XMLDocumentValidator documentValidator : documentValidators) {
            if (document == null) {
                document = documentValidator.getRootElement();
                documentElement = document.getDocumentElement();
                continue;
            }
            NodeList childNodesToAdd = documentValidator.getRootElement().getDocumentElement().getChildNodes();
            for (int i = 0; i < childNodesToAdd.getLength(); ++i) {
                Node node = childNodesToAdd.item(i);
                Node adopted = document.importNode(node, true);
                documentElement.appendChild(adopted);
            }
        }
        byte[] bytes = DSSXMLUtils.serializeNode(documentElement);
        return new InMemoryDocument(bytes, "META-INF/signatures.xml", (MimeType)MimeTypeEnum.XML);
    }
}

