/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.signature;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.SerializableCounterSignatureParameters;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.CounterSignatureService;
import eu.europa.esig.dss.signature.MultipleDocumentsSignatureService;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public abstract class AbstractASiCSignatureService<SP extends SerializableSignatureParameters, TP extends SerializableTimestampParameters, CSP extends SerializableCounterSignatureParameters>
extends AbstractSignatureService<SP, TP>
implements MultipleDocumentsSignatureService<SP, TP>,
CounterSignatureService<CSP> {
    private static final long serialVersionUID = 243114076381526665L;

    protected AbstractASiCSignatureService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, SP parameters) {
        return this.getContentTimestamp(Arrays.asList(toSignDocument), parameters);
    }

    @Override
    public ToBeSigned getDataToSign(DSSDocument toSignDocument, SP parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        return this.getDataToSign(Arrays.asList(toSignDocument), parameters);
    }

    @Override
    public DSSDocument signDocument(DSSDocument toSignDocument, SP parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        return this.signDocument(Arrays.asList(toSignDocument), parameters, signatureValue);
    }

    @Override
    public DSSDocument timestamp(DSSDocument toTimestampDocument, TP parameters) {
        Objects.requireNonNull(toTimestampDocument, "toTimestampDocument cannot be null!");
        return this.timestamp(Arrays.asList(toTimestampDocument), parameters);
    }

    protected ASiCContent extractCurrentArchive(DSSDocument archive) {
        AbstractASiCContainerExtractor extractor = this.getArchiveExtractor(archive);
        return extractor.extract();
    }

    protected abstract AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument var1);

    protected DSSDocument buildASiCContainer(ASiCContent asicContent, Date creationTime) {
        DSSDocument zipArchive = ZipUtils.getInstance().createZipArchive(asicContent, creationTime);
        zipArchive.setMimeType(ASiCUtils.getMimeType(asicContent.getMimeTypeDocument()));
        return zipArchive;
    }

    protected void assertSignaturePossible(List<DSSDocument> documentsToSign) {
        if (Utils.isCollectionEmpty(documentsToSign)) {
            throw new IllegalArgumentException("List of documents to sign cannot be empty!");
        }
        for (DSSDocument document : documentsToSign) {
            if (!(document instanceof DigestDocument)) continue;
            throw new IllegalArgumentException("ASiC container creation is not possible with DigestDocument!");
        }
    }

    protected void assertCounterSignatureParametersValid(CSP parameters) {
        Objects.requireNonNull(parameters.getSignatureIdToCounterSign(), "The Id of a signature to be counter signed shall be defined! Please use SerializableCounterSignatureParameters.setSignatureIdToCounterSign(signatureId) method.");
    }

    protected void assertAddSignaturePolicyStorePossible(ASiCContent asicContent) {
        if (Utils.isCollectionEmpty(asicContent.getSignatureDocuments())) {
            throw new UnsupportedOperationException("Signature documents of the expected format are not found in the provided ASiC Container! Add a SignaturePolicyStore is not possible!");
        }
    }

    protected String getFinalArchiveName(DSSDocument originalFile, SigningOperation operation, MimeType containerMimeType) {
        return this.getFinalDocumentName(originalFile, operation, null, containerMimeType);
    }
}

