/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import eu.europa.esig.dss.asic.common.DSSZipEntry;
import eu.europa.esig.dss.asic.common.DSSZipEntryDocument;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.FileDocument;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileArchiveEntry
extends CommonDocument
implements DSSZipEntryDocument {
    private final FileDocument zipArchive;
    private final ZipEntry zipEntry;
    private final DSSZipEntry dssZipEntry;

    protected FileArchiveEntry(FileDocument zipArchive, ZipEntry zipEntry) {
        Objects.requireNonNull(zipArchive, "ZIP Archive cannot be null!");
        Objects.requireNonNull(zipEntry, "ZIP Entry cannot be null!");
        this.zipArchive = zipArchive;
        this.zipEntry = zipEntry;
        this.dssZipEntry = new DSSZipEntry(zipEntry);
        this.name = this.dssZipEntry.getName();
        this.mimeType = MimeType.fromFileName(this.dssZipEntry.getName());
    }

    @Override
    public InputStream openStream() {
        try {
            return new ZipFileEntryInputStream();
        }
        catch (IOException e) {
            throw new DSSException("Unable to create an InputStream", e);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.dssZipEntry.setName(name);
    }

    @Override
    public DSSZipEntry getZipEntry() {
        return this.dssZipEntry;
    }

    class ZipFileEntryInputStream
    extends InputStream {
        private final ZipFile zipFile;
        private final InputStream entryInputStream;

        ZipFileEntryInputStream() throws IOException {
            this.zipFile = new ZipFile(FileArchiveEntry.this.zipArchive.getFile());
            this.entryInputStream = this.zipFile.getInputStream(FileArchiveEntry.this.zipEntry);
        }

        @Override
        public int read() throws IOException {
            return this.entryInputStream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.entryInputStream.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.entryInputStream.close();
            this.zipFile.close();
        }
    }
}

