/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades;

import eu.europa.esig.dss.asic.cades.DefaultASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.utils.Utils;

public class SimpleASiCWithCAdESFilenameFactory
extends DefaultASiCWithCAdESFilenameFactory {
    private static final long serialVersionUID = 8401330459709076998L;
    private String signatureFilename;
    private String timestampFilename;
    private String manifestFilename;
    private String archiveManifestFilename;
    private String dataPackageFilename;

    @Override
    public String getSignatureFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty(this.signatureFilename)) {
            return this.getValidSignatureFilename(this.signatureFilename, asicContent);
        }
        return super.getSignatureFilename(asicContent);
    }

    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    @Override
    public String getTimestampFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty(this.timestampFilename)) {
            return this.getValidTimestampFilename(this.timestampFilename, asicContent);
        }
        return super.getTimestampFilename(asicContent);
    }

    public void setTimestampFilename(String timestampFilename) {
        this.timestampFilename = timestampFilename;
    }

    @Override
    public String getManifestFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty(this.manifestFilename)) {
            return this.getValidManifestFilename(this.manifestFilename, asicContent);
        }
        return super.getManifestFilename(asicContent);
    }

    public void setManifestFilename(String manifestFilename) {
        this.manifestFilename = manifestFilename;
    }

    @Override
    public String getArchiveManifestFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty(this.archiveManifestFilename)) {
            return this.getValidArchiveManifestFilename(this.archiveManifestFilename, asicContent);
        }
        return super.getArchiveManifestFilename(asicContent);
    }

    public void setArchiveManifestFilename(String archiveManifestFilename) {
        this.archiveManifestFilename = archiveManifestFilename;
    }

    @Override
    public String getDataPackageFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty(this.dataPackageFilename)) {
            return this.getValidDataPackageFilename(this.dataPackageFilename, asicContent);
        }
        return super.getDataPackageFilename(asicContent);
    }

    public void setDataPackageFilename(String dataPackageFilename) {
        this.dataPackageFilename = dataPackageFilename;
    }

    protected String getValidSignatureFilename(String signatureFilename, ASiCContent asicContent) {
        signatureFilename = this.getWithMetaInfFolder(signatureFilename);
        this.assertFilenameValid(signatureFilename, asicContent.getSignatureDocuments());
        if (ASiCUtils.isASiCSContainer(asicContent) && !"META-INF/signature.p7s".equals(signatureFilename)) {
            throw new IllegalArgumentException(String.format("A signature file within ASiC-S with CAdES container shall have name '%s'!", "META-INF/signature.p7s"));
        }
        if (!signatureFilename.startsWith("META-INF/signature") || !signatureFilename.endsWith(".p7s")) {
            throw new IllegalArgumentException(String.format("A signature file within ASiC-E with CAdES container shall match the template '%s'!", "META-INF/signature*.p7s"));
        }
        return signatureFilename;
    }

    protected String getValidTimestampFilename(String timestampFilename, ASiCContent asicContent) {
        timestampFilename = this.getWithMetaInfFolder(timestampFilename);
        this.assertFilenameValid(timestampFilename, asicContent.getTimestampDocuments());
        if (ASiCUtils.isASiCSContainer(asicContent) && Utils.isCollectionEmpty(asicContent.getTimestampDocuments()) && !"META-INF/timestamp.tst".equals(timestampFilename)) {
            throw new IllegalArgumentException(String.format("A timestamp file within ASiC-S with CAdES container shall have name '%s'!", "META-INF/timestamp.tst"));
        }
        if (!timestampFilename.startsWith("META-INF/timestamp") || !timestampFilename.endsWith(".tst")) {
            throw new IllegalArgumentException(String.format("A timestamp file within ASiC-E with CAdES container shall match the template '%s'!", "META-INF/timestamp*.tst"));
        }
        return timestampFilename;
    }

    protected String getValidManifestFilename(String manifestFilename, ASiCContent asicContent) {
        manifestFilename = this.getWithMetaInfFolder(manifestFilename);
        this.assertFilenameValid(manifestFilename, asicContent.getManifestDocuments());
        if (!manifestFilename.startsWith("META-INF/ASiCManifest") || !manifestFilename.endsWith(".xml")) {
            throw new IllegalArgumentException(String.format("A manifest file within ASiC with CAdES container shall match the template '%s'!", "META-INF/ASiCManifest*.xml"));
        }
        return manifestFilename;
    }

    protected String getValidArchiveManifestFilename(String archiveManifestFilename, ASiCContent asicContent) {
        archiveManifestFilename = this.getWithMetaInfFolder(archiveManifestFilename);
        this.assertFilenameValid(archiveManifestFilename, asicContent.getArchiveManifestDocuments());
        if (!archiveManifestFilename.startsWith("META-INF/ASiCArchiveManifest") || !archiveManifestFilename.endsWith(".xml")) {
            throw new IllegalArgumentException(String.format("An archive manifest file within ASiC with CAdES container shall match the template '%s'!", "META-INF/ASiCArchiveManifest*.xml"));
        }
        if ("META-INF/ASiCArchiveManifest.xml".equals(archiveManifestFilename)) {
            throw new IllegalArgumentException(String.format("An archive manifest file within ASiC with CAdES container cannot be moved to a file with name '%s'!", "META-INF/ASiCArchiveManifest.xml"));
        }
        return archiveManifestFilename;
    }
}

