/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCFilenameFactory;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;

public class DefaultASiCWithCAdESFilenameFactory
extends AbstractASiCFilenameFactory
implements ASiCWithCAdESFilenameFactory {
    private static final long serialVersionUID = -4144978379851552021L;

    @Override
    public String getSignatureFilename(ASiCContent asicContent) {
        this.assertASiCContentIsValid(asicContent);
        if (ASiCUtils.isASiCSContainer(asicContent)) {
            return "META-INF/signature.p7s";
        }
        List<String> existingSignatureNames = DSSUtils.getDocumentNames(asicContent.getSignatureDocuments());
        return this.getNextAvailableDocumentName("META-INF/signature001.p7s", existingSignatureNames);
    }

    @Override
    public String getTimestampFilename(ASiCContent asicContent) {
        this.assertASiCContentIsValid(asicContent);
        if (ASiCUtils.isASiCSContainer(asicContent) && Utils.isCollectionEmpty(asicContent.getTimestampDocuments())) {
            return "META-INF/timestamp.tst";
        }
        List<String> existingTimestampNames = DSSUtils.getDocumentNames(asicContent.getTimestampDocuments());
        return this.getNextAvailableDocumentName("META-INF/timestamp001.tst", existingTimestampNames);
    }

    @Override
    public String getManifestFilename(ASiCContent asicContent) {
        this.assertASiCContentIsValid(asicContent);
        if (ASiCUtils.isASiCEContainer(asicContent)) {
            List<String> existingManifestNames = DSSUtils.getDocumentNames(asicContent.getManifestDocuments());
            return this.getNextAvailableDocumentName("META-INF/ASiCManifest001.xml", existingManifestNames);
        }
        throw new UnsupportedOperationException("Manifest is not applicable for ASiC-S with CAdES container!");
    }

    @Override
    public String getArchiveManifestFilename(ASiCContent asicContent) {
        this.assertASiCContentIsValid(asicContent);
        if (ASiCUtils.isASiCEContainer(asicContent) || Utils.isCollectionNotEmpty(asicContent.getTimestampDocuments())) {
            List<String> existingArchiveManifestNames = DSSUtils.getDocumentNames(asicContent.getArchiveManifestDocuments());
            existingArchiveManifestNames.remove("META-INF/ASiCArchiveManifest.xml");
            return this.getNextAvailableDocumentName("META-INF/ASiCArchiveManifest001.xml", existingArchiveManifestNames);
        }
        throw new UnsupportedOperationException("Manifest is not applicable for ASiC-S with CAdES container!");
    }

    @Override
    public String getDataPackageFilename(ASiCContent asicContent) {
        return "package.zip";
    }
}

