/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.utils.Utils;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateReorderer {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateReorderer.class);
    private final CertificateToken signingCertificate;
    private final Collection<CertificateToken> certificateChain;

    public CertificateReorderer(Collection<CertificateToken> certificateChain) {
        this(null, certificateChain);
    }

    public CertificateReorderer(CertificateToken signingCertificate, Collection<CertificateToken> certificateChain) {
        this.signingCertificate = signingCertificate;
        this.certificateChain = certificateChain;
    }

    public List<CertificateToken> getOrderedCertificates() {
        List<CertificateToken> certificates = this.getAllCertificatesOnce();
        if (Utils.collectionSize(certificates) == 1) {
            return certificates;
        }
        this.initIssuerPublicKeys(certificates);
        List<CertificateToken> identifiedSigningCerts = this.getSigningCertificates(certificates);
        CertificateToken selectedSigningCert = this.selectSigningCertificateInList(identifiedSigningCerts);
        List<CertificateToken> rebuiltCertificateChain = this.buildCertificateChainForCert(certificates, selectedSigningCert);
        if (certificates.size() > rebuiltCertificateChain.size()) {
            LOG.debug("Some certificates are ignored");
            LOG.debug("Before : {}", (Object)certificates);
            LOG.debug("After : {}", (Object)rebuiltCertificateChain);
        }
        return rebuiltCertificateChain;
    }

    public Map<CertificateToken, List<CertificateToken>> getOrderedCertificateChains() {
        HashMap<CertificateToken, List<CertificateToken>> result = new HashMap<CertificateToken, List<CertificateToken>>();
        List<CertificateToken> certificates = this.getAllCertificatesOnce();
        if (Utils.collectionSize(certificates) == 1) {
            CertificateToken uniqueCert = certificates.get(0);
            result.put(uniqueCert, Collections.singletonList(uniqueCert));
            return result;
        }
        this.initIssuerPublicKeys(certificates);
        List<CertificateToken> identifiedSigningCerts = this.getSigningCertificates(certificates);
        for (CertificateToken identifiedSigningCert : identifiedSigningCerts) {
            result.put(identifiedSigningCert, this.buildCertificateChainForCert(certificates, identifiedSigningCert));
        }
        return result;
    }

    private void initIssuerPublicKeys(List<CertificateToken> certificates) {
        for (CertificateToken token : certificates) {
            if (!this.isIssuerNeeded(token)) continue;
            for (CertificateToken signer : certificates) {
                if (!token.isSignedBy(signer)) continue;
                LOG.debug("{} is signed by {}", (Object)token.getDSSIdAsString(), (Object)signer.getDSSIdAsString());
                break;
            }
            if (!this.isIssuerNeeded(token)) continue;
            LOG.warn("Issuer not found for certificate {}", (Object)token.getDSSIdAsString());
        }
    }

    private List<CertificateToken> buildCertificateChainForCert(List<CertificateToken> certificates, CertificateToken certToAdd) {
        LinkedList<CertificateToken> result = new LinkedList<CertificateToken>();
        while (certToAdd != null && !result.contains(certToAdd)) {
            result.add(certToAdd);
            certToAdd = this.getCertificateByPubKey(certificates, certToAdd.getPublicKeyOfTheSigner());
        }
        return result;
    }

    private CertificateToken getCertificateByPubKey(List<CertificateToken> certificates, PublicKey publicKeyOfTheSigner) {
        for (CertificateToken certificateToken : certificates) {
            if (!certificateToken.getPublicKey().equals(publicKeyOfTheSigner)) continue;
            return certificateToken;
        }
        return null;
    }

    private boolean isIssuerNeeded(CertificateToken token) {
        return !token.isSelfSigned() && token.getPublicKeyOfTheSigner() == null;
    }

    private CertificateToken selectSigningCertificateInList(List<CertificateToken> identifiedSigningCerts) {
        CertificateToken selectedSigningCert;
        if (identifiedSigningCerts.size() == 1) {
            selectedSigningCert = identifiedSigningCerts.get(0);
        } else {
            LOG.warn("More than one chain detected");
            if (identifiedSigningCerts.contains(this.signingCertificate)) {
                selectedSigningCert = this.signingCertificate;
            } else {
                throw new DSSException("Unable to determine a signing certificate : No pertinent input parameters");
            }
        }
        return selectedSigningCert;
    }

    private List<CertificateToken> getAllCertificatesOnce() {
        ArrayList<CertificateToken> result = new ArrayList<CertificateToken>();
        if (this.signingCertificate != null) {
            result.add(this.signingCertificate);
        }
        if (Utils.isCollectionNotEmpty(this.certificateChain)) {
            for (CertificateToken certificateToken : this.certificateChain) {
                if (certificateToken == null || result.contains(certificateToken)) continue;
                result.add(certificateToken);
            }
        }
        return result;
    }

    private List<CertificateToken> getSigningCertificates(List<CertificateToken> certificates) {
        if (Utils.isCollectionEmpty(certificates)) {
            throw new DSSException("No signing certificate found");
        }
        ArrayList<CertificateToken> potentialSigners = new ArrayList<CertificateToken>();
        for (CertificateToken signer : certificates) {
            boolean isSigner = false;
            for (CertificateToken token : certificates) {
                if (!signer.getPublicKey().equals(token.getPublicKeyOfTheSigner())) continue;
                isSigner = true;
                break;
            }
            if (isSigner) continue;
            potentialSigners.add(signer);
        }
        if (Utils.isCollectionEmpty(potentialSigners)) {
            throw new DSSException("The certificate chain contains only bridge certificates");
        }
        return potentialSigners;
    }
}

