/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.ProfileParameters;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.model.AbstractSerializableSignatureParameters;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SerializableTimestampParameters;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSignatureParameters<TP extends SerializableTimestampParameters>
extends AbstractSerializableSignatureParameters<TP> {
    protected ProfileParameters context;
    private List<DSSDocument> detachedContents;
    private CertificateToken signingCertificate;
    private byte[] signedData;
    private List<CertificateToken> certificateChain = new LinkedList<CertificateToken>();
    private List<TimestampToken> contentTimestamps;

    protected AbstractSignatureParameters() {
    }

    public List<TimestampToken> getContentTimestamps() {
        return this.contentTimestamps;
    }

    public void setContentTimestamps(List<TimestampToken> contentTimestamps) {
        this.contentTimestamps = contentTimestamps;
    }

    public List<DSSDocument> getDetachedContents() {
        if (Utils.isCollectionNotEmpty(this.detachedContents)) {
            return this.detachedContents;
        }
        if (this.context != null) {
            return this.context.getDetachedContents();
        }
        return Collections.emptyList();
    }

    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public CertificateToken getSigningCertificate() {
        return this.signingCertificate;
    }

    public void setSigningCertificate(CertificateToken signingCertificate) {
        this.signingCertificate = signingCertificate;
        this.setEncryptionAlgorithm(EncryptionAlgorithm.forKey(signingCertificate.getPublicKey()));
    }

    public byte[] getSignedData() {
        return this.signedData;
    }

    public void setSignedData(byte[] signedData) {
        this.signedData = signedData;
    }

    public List<CertificateToken> getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(List<CertificateToken> certificateChain) {
        this.certificateChain = certificateChain;
    }

    public void setCertificateChain(CertificateToken ... certificateChainArray) {
        for (CertificateToken certificate : certificateChainArray) {
            if (certificate == null || this.certificateChain.contains(certificate)) continue;
            this.certificateChain.add(certificate);
        }
    }

    public String getDeterministicId() {
        String deterministicId = this.getContext().getDeterministicId();
        if (deterministicId == null) {
            TokenIdentifier identifier = this.getSigningCertificate() == null ? null : this.getSigningCertificate().getDSSId();
            deterministicId = DSSUtils.getDeterministicId(this.bLevel().getSigningDate(), identifier);
            this.getContext().setDeterministicId(deterministicId);
        }
        return deterministicId;
    }

    public ProfileParameters getContext() {
        if (this.context == null) {
            this.context = new ProfileParameters();
        }
        return this.context;
    }

    public void reinit() {
        this.context = null;
    }
}

