/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Objects;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class InMemoryDocument
extends CommonDocument {
    private byte[] bytes;

    public InMemoryDocument() {
    }

    public InMemoryDocument(byte[] bytes) {
        this(bytes, null, null);
    }

    public InMemoryDocument(byte[] bytes, String name) {
        this(bytes, name, MimeType.fromFileName(name));
    }

    public InMemoryDocument(byte[] bytes, String name, MimeType mimeType) {
        Objects.requireNonNull(bytes, "Bytes cannot be null");
        this.bytes = bytes;
        this.name = name;
        this.mimeType = mimeType;
    }

    public InMemoryDocument(InputStream inputStream) {
        this(InMemoryDocument.toByteArray(inputStream), null, null);
    }

    public InMemoryDocument(InputStream inputStream, String name) {
        this(InMemoryDocument.toByteArray(inputStream), name);
    }

    public InMemoryDocument(InputStream inputStream, String name, MimeType mimeType) {
        this(InMemoryDocument.toByteArray(inputStream), name, mimeType);
    }

    private static byte[] toByteArray(InputStream inputStream) {
        byte[] byArray;
        block8: {
            InputStream is = inputStream;
            try {
                byArray = is.readAllBytes();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DSSException("Unable to fully read the InputStream", e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public static InMemoryDocument createEmptyDocument() {
        return new InMemoryDocument(new byte[0]);
    }

    @Override
    public InputStream openStream() {
        Objects.requireNonNull(this.bytes, "Byte array is not defined!");
        return new ByteArrayInputStream(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String getBase64Encoded() {
        Objects.requireNonNull(this.bytes, "Byte array is not defined!");
        return Base64.getEncoder().encodeToString(this.bytes);
    }
}

